/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.job_catalog.JobCatalogListenersList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobCatalogBase
extends AbstractIdleService
implements JobCatalog {
    protected final JobCatalogListenersList listeners;
    protected final Logger log;
    protected final MetricContext metricContext;
    protected final JobCatalog.StandardMetrics metrics;

    public JobCatalogBase() {
        this((Optional<Logger>)Optional.absent());
    }

    public JobCatalogBase(Optional<Logger> log) {
        this(log, (Optional<MetricContext>)Optional.absent(), true);
    }

    public JobCatalogBase(GobblinInstanceEnvironment env) {
        this((Optional<Logger>)Optional.of((Object)env.getLog()), (Optional<MetricContext>)Optional.of((Object)env.getMetricContext()), env.isInstrumentationEnabled());
    }

    public JobCatalogBase(Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) {
        this(log, parentMetricContext, instrumentationEnabled, (Optional<Config>)Optional.absent());
    }

    public JobCatalogBase(Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled, Optional<Config> sysConfig) {
        this.log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        this.listeners = new JobCatalogListenersList(log);
        if (instrumentationEnabled) {
            MetricContext realParentCtx = (MetricContext)parentMetricContext.or((Object)Instrumented.getMetricContext((State)new State(), this.getClass()));
            this.metricContext = realParentCtx.childBuilder(JobCatalog.class.getSimpleName()).build();
            this.metrics = this.createStandardMetrics(sysConfig);
            this.addListener(this.metrics);
        } else {
            this.metricContext = null;
            this.metrics = null;
        }
    }

    protected JobCatalog.StandardMetrics createStandardMetrics(Optional<Config> sysConfig) {
        return new JobCatalog.StandardMetrics(this, sysConfig);
    }

    protected void startUp() throws IOException {
        this.notifyAllListeners();
    }

    protected void shutDown() throws IOException {
        this.listeners.close();
    }

    protected void notifyAllListeners() {
        Collection<JobSpec> jobSpecs = this.getJobsWithTimeUpdate();
        for (JobSpec jobSpec : jobSpecs) {
            this.listeners.onAddJob(jobSpec);
        }
    }

    private Collection<JobSpec> getJobsWithTimeUpdate() {
        long startTime = System.currentTimeMillis();
        Collection jobSpecs = this.getJobs();
        this.metrics.updateGetJobTime(startTime);
        return jobSpecs;
    }

    private Iterator<JobSpec> getJobSpecsWithTimeUpdate() {
        long startTime = System.currentTimeMillis();
        Iterator jobSpecs = this.getJobSpecIterator();
        this.metrics.updateGetJobTime(startTime);
        return jobSpecs;
    }

    @Override
    public synchronized void addListener(JobCatalogListener jobListener) {
        Preconditions.checkNotNull((Object)jobListener);
        this.listeners.addListener(jobListener);
        if (this.state() == Service.State.RUNNING) {
            Iterator<JobSpec> jobSpecItr = this.getJobSpecsWithTimeUpdate();
            while (jobSpecItr.hasNext()) {
                JobSpec jobSpec = jobSpecItr.next();
                if (jobSpec == null) continue;
                JobCatalogListener.AddJobCallback addJobCallback = new JobCatalogListener.AddJobCallback(jobSpec);
                this.listeners.callbackOneListener((Function<JobCatalogListener, Void>)addJobCallback, jobListener);
            }
        }
    }

    @Override
    public synchronized void removeListener(JobCatalogListener jobListener) {
        this.listeners.removeListener(jobListener);
    }

    @Override
    public void registerWeakJobCatalogListener(JobCatalogListener jobListener) {
        this.listeners.registerWeakJobCatalogListener(jobListener);
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return null != this.metricContext;
    }

    public List<Tag<?>> generateTags(State state) {
        return Collections.emptyList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        throw new UnsupportedOperationException();
    }

    public void switchMetricContext(MetricContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JobCatalog.StandardMetrics getMetrics() {
        return this.metrics;
    }
}

