/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.gobblin.util.JobConfigurationUtils;

public class CliOptions {
    public static final Option SYS_CONFIG_OPTION = Option.builder().argName("system configuration file").desc("Gobblin system configuration file").hasArgs().longOpt("sysconfig").build();
    public static final Option JOB_CONFIG_OPTION = Option.builder().argName("job configuration file").desc("Gobblin job configuration file").hasArgs().longOpt("jobconfig").build();
    public static final Option HELP_OPTION = Option.builder((String)"h").argName("help").desc("Display usage information").longOpt("help").build();

    public static Properties parseArgs(Class<?> caller, String[] args) throws IOException {
        try {
            CommandLine cmd = new DefaultParser().parse(CliOptions.options(), args);
            if (cmd.hasOption(HELP_OPTION.getOpt())) {
                CliOptions.printUsage(caller);
                System.exit(0);
            }
            if (!cmd.hasOption(SYS_CONFIG_OPTION.getLongOpt()) || !cmd.hasOption(JOB_CONFIG_OPTION.getLongOpt())) {
                CliOptions.printUsage(caller);
                System.exit(1);
            }
            Properties sysConfig = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(SYS_CONFIG_OPTION.getLongOpt()));
            Properties jobConfig = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(JOB_CONFIG_OPTION.getLongOpt()));
            return JobConfigurationUtils.combineSysAndJobProperties((Properties)sysConfig, (Properties)jobConfig);
        }
        catch (ParseException | ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public static void printUsage(Class<?> caller) {
        new HelpFormatter().printHelp(caller.getSimpleName(), CliOptions.options());
    }

    private static Options options() {
        Options options = new Options();
        options.addOption(SYS_CONFIG_OPTION);
        options.addOption(JOB_CONFIG_OPTION);
        options.addOption(HELP_OPTION);
        return options;
    }
}

