/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.metrics.event.EventName;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.api.EventMetadataGenerator;
import org.apache.gobblin.util.ClassAliasResolver;

public class MultiEventMetadataGenerator {
    private final List<EventMetadataGenerator> eventMetadataGenerators = Lists.newArrayList();

    public MultiEventMetadataGenerator(List<String> multiEventMetadataGeneratorList) {
        for (String eventMetadatadataGeneratorClassName : multiEventMetadataGeneratorList) {
            try {
                ClassAliasResolver aliasResolver = new ClassAliasResolver(EventMetadataGenerator.class);
                this.eventMetadataGenerators.add((EventMetadataGenerator)aliasResolver.resolveClass(eventMetadatadataGeneratorClassName).newInstance());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not construct EventMetadataGenerator " + eventMetadatadataGeneratorClassName, e);
            }
        }
    }

    public Map<String, String> getMetadata(JobContext jobContext, EventName eventName) {
        HashMap metadata = Maps.newHashMap();
        for (EventMetadataGenerator eventMetadataGenerator : this.eventMetadataGenerators) {
            metadata.putAll(eventMetadataGenerator.getMetadata(jobContext, eventName));
        }
        return metadata;
    }
}

