/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Objects;
import java.net.URI;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.util.callbacks.Callback;

@Alpha
public interface JobCatalogListener {
    public void onAddJob(JobSpec var1);

    public void onDeleteJob(URI var1, String var2);

    default public void onCancelJob(URI cancelledJobURI) {
    }

    public void onUpdateJob(JobSpec var1);

    public static class UpdateJobCallback
    extends Callback<JobCatalogListener, Void> {
        private final JobSpec _updatedJob;

        public UpdateJobCallback(JobSpec updatedJob) {
            super(Objects.toStringHelper((String)"onUpdateJob").add("updatedJob", (Object)updatedJob).toString());
            this._updatedJob = updatedJob;
        }

        public Void apply(JobCatalogListener listener) {
            listener.onUpdateJob(this._updatedJob);
            return null;
        }
    }

    public static class CancelJobCallback
    extends Callback<JobCatalogListener, Void> {
        private final URI _cancelledJobURI;

        public CancelJobCallback(URI cancelledJobURI) {
            super(Objects.toStringHelper((String)"onCancelJob").add("cancelJob", (Object)cancelledJobURI).toString());
            this._cancelledJobURI = cancelledJobURI;
        }

        public Void apply(JobCatalogListener listener) {
            listener.onCancelJob(this._cancelledJobURI);
            return null;
        }
    }

    public static class DeleteJobCallback
    extends Callback<JobCatalogListener, Void> {
        private final URI _deletedJobURI;
        private final String _deletedJobVersion;

        public DeleteJobCallback(URI deletedJobURI, String deletedJobVersion) {
            super(Objects.toStringHelper((String)"onDeleteJob").add("deletedJobURI", (Object)deletedJobURI).add("deletedJobVersion", (Object)deletedJobVersion).toString());
            this._deletedJobURI = deletedJobURI;
            this._deletedJobVersion = deletedJobVersion;
        }

        public Void apply(JobCatalogListener listener) {
            listener.onDeleteJob(this._deletedJobURI, this._deletedJobVersion);
            return null;
        }
    }

    public static class AddJobCallback
    extends Callback<JobCatalogListener, Void> {
        private final JobSpec _addedJob;

        public AddJobCallback(JobSpec addedJob) {
            super(Objects.toStringHelper((String)"onAddJob").add("addedJob", (Object)addedJob).toString());
            this._addedJob = addedJob;
        }

        public Void apply(JobCatalogListener listener) {
            listener.onAddJob(this._addedJob);
            return null;
        }
    }
}

