/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.linkedin.data.template.StringMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.service.FlowConfig;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.Schedule;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="FindBugs complains about Config not being serializable, but the implementation of Config is serializable")
public class FlowSpec
implements Configurable,
Spec {
    private static final long serialVersionUID = -5511988862945107734L;
    final URI uri;
    final String version;
    final String description;
    final Config config;
    final Properties configAsProperties;
    final Optional<Set<URI>> templateURIs;
    final Optional<List<Spec>> childSpecs;
    final Set<String> compilationErrors = new HashSet<String>();

    public static Builder builder(URI flowSpecUri) {
        return new Builder(flowSpecUri);
    }

    public static Builder builder(String flowSpecUri) {
        return new Builder(flowSpecUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(URI catalogURI, Properties flowProps) {
        String name = flowProps.getProperty("flow.name");
        String group = flowProps.getProperty("flow.group", "default");
        try {
            URI flowURI = new URI(catalogURI.getScheme(), catalogURI.getAuthority(), "/" + group + "/" + name, null);
            Builder builder = new Builder(flowURI).withConfigAsProperties(flowProps);
            String descr = flowProps.getProperty("flow.description", null);
            if (null != descr) {
                builder = builder.withDescription(descr);
            }
            return builder;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create a FlowSpec URI: " + e, e);
        }
    }

    public String toShortString() {
        return this.getUri().toString() + "/" + this.getVersion();
    }

    public String toLongString() {
        return this.getUri().toString() + "/" + this.getVersion() + "[" + this.getDescription() + "]";
    }

    public String toString() {
        return this.toShortString();
    }

    public URI getUri() {
        return this.uri;
    }

    public Boolean isExplain() {
        return ConfigUtils.getBoolean((Config)this.getConfig(), (String)"flow.explain", (boolean)false);
    }

    public boolean isScheduled() {
        return this.getConfig().hasPath("job.schedule");
    }

    public FlowSpec(URI uri, String version, String description, Config config, Properties configAsProperties, Optional<Set<URI>> templateURIs, Optional<List<Spec>> childSpecs) {
        this.uri = uri;
        this.version = version;
        this.description = description;
        this.config = config;
        this.configAsProperties = configAsProperties;
        this.templateURIs = templateURIs;
        this.childSpecs = childSpecs;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Properties getConfigAsProperties() {
        return this.configAsProperties;
    }

    public Optional<Set<URI>> getTemplateURIs() {
        return this.templateURIs;
    }

    public Optional<List<Spec>> getChildSpecs() {
        return this.childSpecs;
    }

    public Set<String> getCompilationErrors() {
        return this.compilationErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowSpec)) {
            return false;
        }
        FlowSpec other = (FlowSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Properties this$configAsProperties = this.getConfigAsProperties();
        Properties other$configAsProperties = other.getConfigAsProperties();
        if (this$configAsProperties == null ? other$configAsProperties != null : !((Object)this$configAsProperties).equals(other$configAsProperties)) {
            return false;
        }
        Optional<Set<URI>> this$templateURIs = this.getTemplateURIs();
        Optional<Set<URI>> other$templateURIs = other.getTemplateURIs();
        if (this$templateURIs == null ? other$templateURIs != null : !this$templateURIs.equals(other$templateURIs)) {
            return false;
        }
        Optional<List<Spec>> this$childSpecs = this.getChildSpecs();
        Optional<List<Spec>> other$childSpecs = other.getChildSpecs();
        return !(this$childSpecs == null ? other$childSpecs != null : !this$childSpecs.equals(other$childSpecs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Properties $configAsProperties = this.getConfigAsProperties();
        result = result * 59 + ($configAsProperties == null ? 43 : ((Object)$configAsProperties).hashCode());
        Optional<Set<URI>> $templateURIs = this.getTemplateURIs();
        result = result * 59 + ($templateURIs == null ? 43 : $templateURIs.hashCode());
        Optional<List<Spec>> $childSpecs = this.getChildSpecs();
        result = result * 59 + ($childSpecs == null ? 43 : $childSpecs.hashCode());
        return result;
    }

    public static class Utils {
        private static final Logger log = LoggerFactory.getLogger(Utils.class);
        private static final String URI_SCHEME = "gobblin-flow";
        private static final String URI_AUTHORITY = null;
        private static final String URI_PATH_SEPARATOR = "/";
        private static final String URI_QUERY = null;
        private static final String URI_FRAGMENT = null;
        private static final int EXPECTED_NUM_URI_PATH_TOKENS = 3;

        public static URI createFlowSpecUri(FlowId flowId) throws URISyntaxException {
            return new URI(URI_SCHEME, URI_AUTHORITY, Utils.createUriPath(flowId), URI_QUERY, URI_FRAGMENT);
        }

        private static String createUriPath(FlowId flowId) {
            return URI_PATH_SEPARATOR + flowId.getFlowGroup() + URI_PATH_SEPARATOR + flowId.getFlowName();
        }

        public static String getFlowName(URI flowUri) {
            String[] uriTokens = flowUri.getPath().split(URI_PATH_SEPARATOR);
            if (uriTokens.length != 3) {
                log.error("Invalid URI {}.", (Object)flowUri);
                return null;
            }
            return uriTokens[2];
        }

        public static String getFlowGroup(URI flowUri) {
            String[] uriTokens = flowUri.getPath().split(URI_PATH_SEPARATOR);
            if (uriTokens.length != 3) {
                log.error("Invalid URI {}.", (Object)flowUri);
                return null;
            }
            return uriTokens[1];
        }

        public static FlowConfig toFlowConfig(Spec spec) {
            FlowSpec flowSpec = (FlowSpec)spec;
            FlowConfig flowConfig = new FlowConfig();
            Properties flowProps = flowSpec.getConfigAsProperties();
            Schedule schedule = null;
            if (flowProps.containsKey("job.schedule")) {
                schedule = new Schedule();
                schedule.setCronSchedule(flowProps.getProperty("job.schedule"));
            }
            if (flowProps.containsKey("job.template")) {
                flowConfig.setTemplateUris(flowProps.getProperty("job.template"));
            } else if (flowSpec.getTemplateURIs().isPresent()) {
                flowConfig.setTemplateUris(StringUtils.join((Collection)((Collection)flowSpec.getTemplateURIs().get()), (String)","));
            } else {
                flowConfig.setTemplateUris("NA");
            }
            if (schedule != null) {
                if (flowProps.containsKey("flow.runImmediately")) {
                    schedule.setRunImmediately(Boolean.valueOf(flowProps.getProperty("flow.runImmediately")));
                }
                flowConfig.setSchedule(schedule);
            }
            if (flowProps.containsKey("flow.owningGroup")) {
                flowConfig.setOwningGroup(flowProps.getProperty("flow.owningGroup"));
            }
            flowProps.remove("job.schedule");
            flowProps.remove("job.template");
            StringMap flowPropsAsStringMap = new StringMap();
            flowPropsAsStringMap.putAll((Map)Maps.fromProperties((Properties)flowProps));
            return flowConfig.setId(new FlowId().setFlowGroup(flowProps.getProperty("flow.group")).setFlowName(flowProps.getProperty("flow.name"))).setProperties(flowPropsAsStringMap);
        }

        public static int maxFlowSpecUriLength() {
            return URI_SCHEME.length() + ":".length() + URI_PATH_SEPARATOR.length() + 128 + URI_PATH_SEPARATOR.length() + 128;
        }
    }

    public static class Builder {
        public static final String DEFAULT_FLOW_CATALOG_SCHEME = "gobblin-flow";
        public static final String DEFAULT_VERSION = "";
        @VisibleForTesting
        private Optional<Config> config = Optional.absent();
        private Optional<Properties> configAsProperties = Optional.absent();
        private Optional<URI> uri;
        private String version = "";
        private Optional<String> description = Optional.absent();
        private Optional<URI> flowCatalogURI = Optional.absent();
        private Optional<Set<URI>> templateURIs = Optional.absent();
        private Optional<List<Spec>> childSpecs = Optional.absent();

        public Builder(URI flowSpecUri) {
            Preconditions.checkNotNull((Object)flowSpecUri);
            this.uri = Optional.of((Object)flowSpecUri);
        }

        public Builder(String flowSpecUri) {
            Preconditions.checkNotNull((Object)flowSpecUri);
            Preconditions.checkNotNull((Object)flowSpecUri);
            try {
                this.uri = Optional.of((Object)new URI(flowSpecUri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid FlowSpec config: " + e, e);
            }
        }

        public Builder() {
            this.uri = Optional.absent();
        }

        public FlowSpec build() {
            Preconditions.checkNotNull(this.uri);
            Preconditions.checkArgument((null != this.version ? 1 : 0) != 0, (Object)"Version should not be null");
            return new FlowSpec(this.getURI(), this.getVersion(), this.getDescription(), this.getConfig(), this.getConfigAsProperties(), this.getTemplateURIs(), this.getChildSpecs());
        }

        public Builder withFlowCatalogURI(URI flowCatalogURI) {
            this.flowCatalogURI = Optional.of((Object)flowCatalogURI);
            return this;
        }

        public Builder withFlowCatalogURI(String flowCatalogURI) {
            try {
                this.flowCatalogURI = Optional.of((Object)new URI(flowCatalogURI));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to set flow catalog URI: " + e, e);
            }
            return this;
        }

        public URI getDefaultFlowCatalogURI() {
            try {
                return new URI(DEFAULT_FLOW_CATALOG_SCHEME, null, "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected exception: " + e, e);
            }
        }

        public URI getFlowCatalogURI() {
            if (!this.flowCatalogURI.isPresent()) {
                this.flowCatalogURI = Optional.of((Object)this.getDefaultFlowCatalogURI());
            }
            return (URI)this.flowCatalogURI.get();
        }

        public URI getDefaultURI() {
            URI flowCatalogURI = this.getFlowCatalogURI();
            Config flowCfg = this.getConfig();
            String name = flowCfg.hasPath("flow.name") ? flowCfg.getString("flow.name") : "default";
            String group = flowCfg.hasPath("flow.group") ? flowCfg.getString("flow.group") : "default";
            try {
                return new URI(flowCatalogURI.getScheme(), flowCatalogURI.getAuthority(), "/" + group + "/" + name, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to create default FlowSpec URI:" + e, e);
            }
        }

        public URI getURI() {
            if (!this.uri.isPresent()) {
                this.uri = Optional.of((Object)this.getDefaultURI());
            }
            return (URI)this.uri.get();
        }

        public Builder withVersion(String version) {
            Preconditions.checkNotNull((Object)version);
            this.version = version;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder withDescription(String flowDescription) {
            Preconditions.checkNotNull((Object)flowDescription);
            this.description = Optional.of((Object)flowDescription);
            return this;
        }

        public String getDefaultDescription() {
            Config flowConf = this.getConfig();
            return flowConf.hasPath("flow.description") ? flowConf.getString("flow.description") : "Gobblin flow " + this.getURI();
        }

        public String getDescription() {
            if (!this.description.isPresent()) {
                this.description = Optional.of((Object)this.getDefaultDescription());
            }
            return (String)this.description.get();
        }

        public Config getDefaultConfig() {
            return ConfigFactory.empty();
        }

        public Config getConfig() {
            if (!this.config.isPresent()) {
                this.config = this.configAsProperties.isPresent() ? Optional.of((Object)ConfigUtils.propertiesToTypedConfig((Properties)((Properties)this.configAsProperties.get()), (Optional)Optional.absent())) : Optional.of((Object)this.getDefaultConfig());
            }
            return (Config)this.config.get();
        }

        public Builder withConfig(Config flowConfig) {
            Preconditions.checkNotNull((Object)flowConfig);
            this.config = Optional.of((Object)flowConfig);
            return this;
        }

        public Properties getConfigAsProperties() {
            if (!this.configAsProperties.isPresent()) {
                this.configAsProperties = Optional.of((Object)ConfigUtils.configToProperties((Config)((Config)this.config.get())));
            }
            return (Properties)this.configAsProperties.get();
        }

        public Builder withConfigAsProperties(Properties flowConfig) {
            Preconditions.checkNotNull((Object)flowConfig);
            this.configAsProperties = Optional.of((Object)flowConfig);
            return this;
        }

        public Optional<Set<URI>> getTemplateURIs() {
            return this.templateURIs;
        }

        public Builder withTemplate(URI templateURI) {
            Preconditions.checkNotNull((Object)templateURI);
            if (!this.templateURIs.isPresent()) {
                HashSet templateURISet = Sets.newHashSet();
                this.templateURIs = Optional.of((Object)templateURISet);
            }
            ((Set)this.templateURIs.get()).add(templateURI);
            return this;
        }

        public Builder withTemplates(Collection templateURIs) {
            Preconditions.checkNotNull((Object)templateURIs);
            if (!this.templateURIs.isPresent()) {
                HashSet templateURISet = Sets.newHashSet();
                this.templateURIs = Optional.of((Object)templateURISet);
            }
            ((Set)this.templateURIs.get()).addAll(templateURIs);
            return this;
        }

        public Optional<List<Spec>> getChildSpecs() {
            return this.childSpecs;
        }

        public Builder withChildSpec(Spec childSpec) {
            Preconditions.checkNotNull((Object)childSpec);
            if (!this.childSpecs.isPresent()) {
                ArrayList childSpecsList = Lists.newArrayList();
                this.childSpecs = Optional.of((Object)childSpecsList);
            }
            ((List)this.childSpecs.get()).add(childSpec);
            return this;
        }

        public Builder withChildSpecs(List<Spec> childSpecs) {
            Preconditions.checkNotNull(childSpecs);
            if (!this.childSpecs.isPresent()) {
                ArrayList childSpecsList = Lists.newArrayList();
                this.childSpecs = Optional.of((Object)childSpecsList);
            }
            ((List)this.childSpecs.get()).addAll(childSpecs);
            return this;
        }
    }
}

