/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.app;

import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.rest.JobExecutionInfoServer;
import org.apache.gobblin.runtime.api.AdminWebServerFactory;
import org.apache.gobblin.runtime.app.ApplicationException;
import org.apache.gobblin.runtime.app.ApplicationLauncher;
import org.apache.gobblin.runtime.services.JMXReportingService;
import org.apache.gobblin.runtime.services.MetricsReportingService;
import org.apache.gobblin.util.ApplicationLauncherUtils;
import org.apache.gobblin.util.ClassAliasResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class ServiceBasedAppLauncher
implements ApplicationLauncher {
    public static final String APP_NAME = "app.name";
    public static final String APP_STOP_TIME_SECONDS = "app.stop.time.seconds";
    private static final String DEFAULT_APP_STOP_TIME_SECONDS = Long.toString(60L);
    public static final String APP_ADDITIONAL_SERVICES = "app.additional.services";
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBasedAppLauncher.class);
    private final int stopTime;
    private final String appId;
    private final List<Service> services;
    private volatile boolean hasStarted = false;
    private volatile boolean hasStopped = false;
    private ServiceManager serviceManager;

    public ServiceBasedAppLauncher(Properties properties, String appName) throws Exception {
        this.stopTime = Integer.parseInt(properties.getProperty(APP_STOP_TIME_SECONDS, DEFAULT_APP_STOP_TIME_SECONDS));
        this.appId = ApplicationLauncherUtils.newAppId((String)appName);
        this.services = new ArrayList<Service>();
        this.addJobExecutionServerAndAdminUI(properties);
        this.addMetricsService(properties);
        this.addJMXReportingService();
        this.addServicesFromProperties(properties);
        this.addInterruptedShutdownHook();
    }

    @Override
    public synchronized void start() {
        if (this.hasStarted) {
            LOG.warn("ApplicationLauncher has already started");
            return;
        }
        this.hasStarted = true;
        this.serviceManager = new ServiceManager(this.services);
        this.serviceManager.addListener(new ServiceManager.Listener(){

            public void failure(Service service) {
                super.failure(service);
                LOG.error(String.format("Service %s has failed.", service.getClass().getSimpleName()), service.failureCause());
                try {
                    service.stopAsync();
                    ServiceBasedAppLauncher.this.stop();
                }
                catch (ApplicationException ae) {
                    LOG.error("Could not shutdown services gracefully. This may cause the application to hang.");
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ServiceBasedAppLauncher.this.stop();
                }
                catch (ApplicationException e) {
                    LOG.error("Failed to shutdown application", (Throwable)e);
                }
                finally {
                    try {
                        ServiceBasedAppLauncher.this.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close application", (Throwable)e);
                    }
                }
            }
        });
        LOG.info("Starting the Gobblin application and all its associated Services");
        this.serviceManager.startAsync().awaitHealthy();
    }

    @Override
    public synchronized void stop() throws ApplicationException {
        if (!this.hasStarted) {
            LOG.warn("ApplicationLauncher was never started");
            return;
        }
        if (this.hasStopped) {
            LOG.warn("ApplicationLauncher has already stopped");
            return;
        }
        this.hasStopped = true;
        LOG.info("Shutting down the application");
        try {
            this.serviceManager.stopAsync().awaitStopped((long)this.stopTime, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            LOG.error("Timeout in stopping the service manager", (Throwable)te);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public void addService(Service service) {
        if (this.hasStarted) {
            throw new IllegalArgumentException("Cannot add a service while the application is running!");
        }
        this.services.add(service);
    }

    private void addJobExecutionServerAndAdminUI(Properties properties) {
        boolean jobExecInfoServerEnabled = Boolean.valueOf(properties.getProperty("job.execinfo.server.enabled", Boolean.FALSE.toString()));
        boolean adminUiServerEnabled = Boolean.valueOf(properties.getProperty("admin.server.enabled", Boolean.FALSE.toString()));
        if (jobExecInfoServerEnabled) {
            LOG.info("Will launch the job execution info server");
            JobExecutionInfoServer executionInfoServer = new JobExecutionInfoServer(properties);
            this.addService((Service)executionInfoServer);
            if (adminUiServerEnabled) {
                LOG.info("Will launch the admin UI server");
                this.addService(ServiceBasedAppLauncher.createAdminServer(properties, executionInfoServer.getAdvertisedServerUri()));
            }
        } else if (adminUiServerEnabled) {
            LOG.warn("Not launching the admin UI because the job execution info server is not enabled");
        }
    }

    public static Service createAdminServer(Properties properties, URI executionInfoServerURI) {
        String factoryClassName = properties.getProperty("admin.server.factory.type", "org.apache.gobblin.admin.DefaultAdminWebServerFactory");
        ClassAliasResolver classResolver = new ClassAliasResolver(AdminWebServerFactory.class);
        try {
            AdminWebServerFactory factoryInstance = (AdminWebServerFactory)classResolver.resolveClass(factoryClassName).newInstance();
            return factoryInstance.createInstance(properties, executionInfoServerURI);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate the AdminWebServer factory. Have you included the module in the gobblin distribution? :" + e, e);
        }
    }

    private void addMetricsService(Properties properties) {
        if (GobblinMetrics.isEnabled((Properties)properties)) {
            this.addService((Service)new MetricsReportingService(properties, this.appId));
        }
    }

    private void addJMXReportingService() {
        this.addService((Service)new JMXReportingService());
    }

    private void addServicesFromProperties(Properties properties) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        if (properties.containsKey(APP_ADDITIONAL_SERVICES)) {
            for (String serviceClassName : new State(properties).getPropAsSet(APP_ADDITIONAL_SERVICES)) {
                Class<?> serviceClass = Class.forName(serviceClassName);
                if (Service.class.isAssignableFrom(serviceClass)) {
                    Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(serviceClass, (Class[])new Class[]{Properties.class});
                    Service service = constructor != null ? (Service)constructor.newInstance(properties) : (Service)serviceClass.newInstance();
                    this.addService(service);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Class %s specified by %s does not implement %s", serviceClassName, APP_ADDITIONAL_SERVICES, Service.class.getSimpleName()));
            }
        }
    }

    private void addInterruptedShutdownHook() {
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                mainThread.interrupt();
            }
        });
    }
}

