/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.spec_executorInstance.InMemorySpecExecutor;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;

@Alpha
@NotThreadSafe
public class TopologySpec
implements Configurable,
Spec {
    public static final String DEFAULT_SPEC_EXECUTOR_INSTANCE = InMemorySpecExecutor.class.getCanonicalName();
    public static final String SPEC_EXECUTOR_INSTANCE_KEY = "specExecutorInstance.class";
    private static final long serialVersionUID = 6106269076155338046L;
    final URI uri;
    final String version;
    final String description;
    @SuppressWarnings(justification="No bug", value={"SE_BAD_FIELD"})
    final Config config;
    final Properties configAsProperties;
    @SuppressWarnings(justification="Initialization handled by getter", value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    transient SpecExecutor specExecutorInstance;

    public synchronized SpecExecutor getSpecExecutor() {
        if (null == this.specExecutorInstance) {
            String specExecutorClass = DEFAULT_SPEC_EXECUTOR_INSTANCE;
            if (this.config.hasPath(SPEC_EXECUTOR_INSTANCE_KEY)) {
                specExecutorClass = this.config.getString(SPEC_EXECUTOR_INSTANCE_KEY);
            }
            try {
                ClassAliasResolver _aliasResolver = new ClassAliasResolver(SpecExecutor.class);
                this.specExecutorInstance = (SpecExecutor)ConstructorUtils.invokeConstructor(Class.forName(_aliasResolver.resolve(specExecutorClass)), (Object[])new Object[]{this.config});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.specExecutorInstance;
    }

    public static Builder builder(URI topologySpecUri) {
        return new Builder(topologySpecUri);
    }

    public static Builder builder(String topologySpecUri) {
        return new Builder(topologySpecUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(URI catalogURI, Properties topologyProps) {
        String name = topologyProps.getProperty("topology.name");
        String group = topologyProps.getProperty("topology.group", "default");
        try {
            URI topologyURI = new URI(catalogURI.getScheme(), catalogURI.getAuthority(), "/" + group + "/" + name, null);
            Builder builder = new Builder(topologyURI).withConfigAsProperties(topologyProps);
            String descr = topologyProps.getProperty("topology.description", null);
            if (null != descr) {
                builder = builder.withDescription(descr);
            }
            return builder;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create a TopologySpec URI: " + e, e);
        }
    }

    public String toShortString() {
        return this.getUri().toString() + "/" + this.getVersion();
    }

    public String toLongString() {
        return this.getUri().toString() + "/" + this.getVersion() + "[" + this.getDescription() + "]";
    }

    public String toString() {
        return this.toShortString();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Properties getConfigAsProperties() {
        return this.configAsProperties;
    }

    public SpecExecutor getSpecExecutorInstance() {
        return this.specExecutorInstance;
    }

    public void setSpecExecutorInstance(SpecExecutor specExecutorInstance) {
        this.specExecutorInstance = specExecutorInstance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologySpec)) {
            return false;
        }
        TopologySpec other = (TopologySpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Properties this$configAsProperties = this.getConfigAsProperties();
        Properties other$configAsProperties = other.getConfigAsProperties();
        return !(this$configAsProperties == null ? other$configAsProperties != null : !((Object)this$configAsProperties).equals(other$configAsProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopologySpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Properties $configAsProperties = this.getConfigAsProperties();
        result = result * 59 + ($configAsProperties == null ? 43 : ((Object)$configAsProperties).hashCode());
        return result;
    }

    @ConstructorProperties(value={"uri", "version", "description", "config", "configAsProperties", "specExecutorInstance"})
    public TopologySpec(URI uri, String version, String description, Config config, Properties configAsProperties, SpecExecutor specExecutorInstance) {
        this.uri = uri;
        this.version = version;
        this.description = description;
        this.config = config;
        this.configAsProperties = configAsProperties;
        this.specExecutorInstance = specExecutorInstance;
    }

    public static class Builder {
        public static final String DEFAULT_TOPOLOGY_CATALOG_SCHEME = "gobblin-topology";
        @VisibleForTesting
        private Optional<Config> config = Optional.absent();
        private Optional<Properties> configAsProperties = Optional.absent();
        private Optional<URI> uri;
        private String version = "1";
        private Optional<String> description = Optional.absent();
        private Optional<URI> topologyCatalogURI = Optional.absent();
        private Optional<SpecExecutor> specExecutorInstance = Optional.absent();

        public Builder(URI topologySpecUri) {
            Preconditions.checkNotNull((Object)topologySpecUri);
            this.uri = Optional.of((Object)topologySpecUri);
        }

        public Builder(String topologySpecUri) {
            Preconditions.checkNotNull((Object)topologySpecUri);
            Preconditions.checkNotNull((Object)topologySpecUri);
            try {
                this.uri = Optional.of((Object)new URI(topologySpecUri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid TopologySpec config: " + e, e);
            }
        }

        public Builder() {
            this.uri = Optional.absent();
        }

        public TopologySpec build() {
            Preconditions.checkNotNull(this.uri);
            Preconditions.checkNotNull((Object)this.version);
            return new TopologySpec(this.getURI(), this.getVersion(), this.getDescription(), this.getConfig(), this.getConfigAsProperties(), this.getSpecExceutorInstance());
        }

        public Builder withTopologyCatalogURI(URI topologyCatalogURI) {
            this.topologyCatalogURI = Optional.of((Object)topologyCatalogURI);
            return this;
        }

        public Builder withTopologyCatalogURI(String topologyCatalogURI) {
            try {
                this.topologyCatalogURI = Optional.of((Object)new URI(topologyCatalogURI));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to set topology catalog URI: " + e, e);
            }
            return this;
        }

        public URI getDefaultTopologyCatalogURI() {
            try {
                return new URI(DEFAULT_TOPOLOGY_CATALOG_SCHEME, null, "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected exception: " + e, e);
            }
        }

        public URI getTopologyCatalogURI() {
            if (!this.topologyCatalogURI.isPresent()) {
                this.topologyCatalogURI = Optional.of((Object)this.getDefaultTopologyCatalogURI());
            }
            return (URI)this.topologyCatalogURI.get();
        }

        public URI getDefaultURI() {
            URI topologyCatalogURI = this.getTopologyCatalogURI();
            Config topologyCfg = this.getConfig();
            String name = topologyCfg.hasPath("topology.name") ? topologyCfg.getString("topology.name") : "default";
            String group = topologyCfg.hasPath("topology.group") ? topologyCfg.getString("topology.group") : "default";
            try {
                return new URI(topologyCatalogURI.getScheme(), topologyCatalogURI.getAuthority(), "/" + group + "/" + name, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to create default TopologySpec URI:" + e, e);
            }
        }

        public URI getURI() {
            if (!this.uri.isPresent()) {
                this.uri = Optional.of((Object)this.getDefaultURI());
            }
            return (URI)this.uri.get();
        }

        public Builder withVersion(String version) {
            Preconditions.checkNotNull((Object)version);
            this.version = version;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder withDescription(String topologyDescription) {
            Preconditions.checkNotNull((Object)topologyDescription);
            this.description = Optional.of((Object)topologyDescription);
            return this;
        }

        public String getDefaultDescription() {
            Config topologyConf = this.getConfig();
            return topologyConf.hasPath("topology.description") ? topologyConf.getString("topology.description") : "Gobblin topology " + this.getURI();
        }

        public String getDescription() {
            if (!this.description.isPresent()) {
                this.description = Optional.of((Object)this.getDefaultDescription());
            }
            return (String)this.description.get();
        }

        public Config getDefaultConfig() {
            return ConfigFactory.empty();
        }

        public Config getConfig() {
            if (!this.config.isPresent()) {
                this.config = this.configAsProperties.isPresent() ? Optional.of((Object)ConfigUtils.propertiesToTypedConfig((Properties)((Properties)this.configAsProperties.get()), (Optional)Optional.absent())) : Optional.of((Object)this.getDefaultConfig());
            }
            return (Config)this.config.get();
        }

        public Builder withConfig(Config topologyConfig) {
            Preconditions.checkNotNull((Object)topologyConfig);
            this.config = Optional.of((Object)topologyConfig);
            return this;
        }

        public Properties getConfigAsProperties() {
            if (!this.configAsProperties.isPresent()) {
                this.configAsProperties = Optional.of((Object)ConfigUtils.configToProperties((Config)((Config)this.config.get())));
            }
            return (Properties)this.configAsProperties.get();
        }

        public Builder withConfigAsProperties(Properties topologyConfig) {
            Preconditions.checkNotNull((Object)topologyConfig);
            this.configAsProperties = Optional.of((Object)topologyConfig);
            return this;
        }

        public SpecExecutor getSpecExceutorInstance() {
            if (!this.specExecutorInstance.isPresent()) {
                throw new RuntimeException("SpecExecutor not initialized.");
            }
            return (SpecExecutor)this.specExecutorInstance.get();
        }

        public Builder withSpecExecutor(SpecExecutor specExecutor) {
            Preconditions.checkNotNull((Object)specExecutor);
            this.specExecutorInstance = Optional.of((Object)specExecutor);
            return this;
        }
    }
}

