/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.ExecutionResult;
import org.apache.gobblin.runtime.api.JobExecutionState;

public class JobExecutionResult
implements ExecutionResult {
    private final JobState.RunningState finalState;
    private final Throwable errorCause;

    public boolean isCancelled() {
        return JobState.RunningState.CANCELLED == this.getFinalState();
    }

    public boolean isSuccessful() {
        return JobState.RunningState.COMMITTED == this.getFinalState();
    }

    public boolean isFailed() {
        return JobState.RunningState.FAILED == this.getFinalState();
    }

    public static JobExecutionResult createSuccessResult() {
        return new JobExecutionResult(JobState.RunningState.COMMITTED, null);
    }

    public static JobExecutionResult createFailureResult(Throwable cause) {
        return new JobExecutionResult(JobState.RunningState.FAILED, cause);
    }

    public static JobExecutionResult createCancelledResult() {
        return new JobExecutionResult(JobState.RunningState.CANCELLED, null);
    }

    public static JobExecutionResult createFromState(JobExecutionState state) {
        Preconditions.checkArgument((null != state.getRunningState() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)state.getRunningState().isDone());
        if (state.getRunningState().isSuccess()) {
            return JobExecutionResult.createSuccessResult();
        }
        if (state.getRunningState().isCancelled()) {
            return JobExecutionResult.createCancelledResult();
        }
        return JobExecutionResult.createFailureResult(new RuntimeException("Gobblin job failed:" + state.getJobExecution()));
    }

    @ConstructorProperties(value={"finalState", "errorCause"})
    protected JobExecutionResult(JobState.RunningState finalState, Throwable errorCause) {
        this.finalState = finalState;
        this.errorCause = errorCause;
    }

    public JobState.RunningState getFinalState() {
        return this.finalState;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }
}

