/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.scheduler;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.util.Properties;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerService
extends AbstractIdleService {
    private Scheduler scheduler;
    private final boolean waitForJobCompletion;
    private final Optional<Properties> quartzProps;

    public SchedulerService(boolean waitForJobCompletion, Optional<Properties> quartzConfig) {
        this.waitForJobCompletion = waitForJobCompletion;
        this.quartzProps = quartzConfig;
    }

    public SchedulerService(Properties props) {
        this(Boolean.parseBoolean(props.getProperty("scheduler.wait.for.job.completion", ConfigurationKeys.DEFAULT_SCHEDULER_WAIT_FOR_JOB_COMPLETION)), (Optional<Properties>)Optional.of((Object)PropertiesUtils.extractPropertiesWithPrefix((Properties)props, (Optional)Optional.of((Object)"org.quartz."))));
    }

    public SchedulerService(Config cfg) {
        this(cfg.hasPath("scheduler.wait.for.job.completion") ? cfg.getBoolean("scheduler.wait.for.job.completion") : Boolean.parseBoolean(ConfigurationKeys.DEFAULT_SCHEDULER_WAIT_FOR_JOB_COMPLETION), (Optional<Properties>)Optional.of((Object)ConfigUtils.configToProperties((Config)cfg, (String)"org.quartz.")));
    }

    protected void startUp() throws SchedulerException {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        if (this.quartzProps.isPresent() && ((Properties)this.quartzProps.get()).size() > 0) {
            schedulerFactory.initialize((Properties)this.quartzProps.get());
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
    }

    protected void shutDown() throws SchedulerException {
        this.scheduler.shutdown(this.waitForJobCompletion);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

