/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_spec;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.net.URI;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.InMemoryJobCatalog;
import org.apache.gobblin.runtime.job_catalog.PackagedTemplatesJobCatalogDecorator;
import org.apache.gobblin.util.ConfigUtils;

public class ResolvedJobSpec
extends JobSpec {
    private final JobSpec originalJobSpec;

    public ResolvedJobSpec(JobSpec other) throws SpecNotFoundException, JobTemplate.TemplateException {
        this(other, new InMemoryJobCatalog());
    }

    public ResolvedJobSpec(JobSpec other, GobblinInstanceDriver driver) throws SpecNotFoundException, JobTemplate.TemplateException {
        this(other, driver.getJobCatalog());
    }

    public ResolvedJobSpec(JobSpec other, JobCatalog catalog) throws SpecNotFoundException, JobTemplate.TemplateException {
        super(other.getUri(), other.getVersion(), other.getDescription(), ResolvedJobSpec.resolveConfig(other, catalog), ConfigUtils.configToProperties((Config)ResolvedJobSpec.resolveConfig(other, catalog)), other.getTemplateURI(), other.getMetadata());
        this.originalJobSpec = other;
    }

    private static Config resolveConfig(JobSpec jobSpec, JobCatalog catalog) throws SpecNotFoundException, JobTemplate.TemplateException {
        Optional<URI> templateURIOpt = jobSpec.getTemplateURI();
        if (templateURIOpt.isPresent()) {
            PackagedTemplatesJobCatalogDecorator catalogWithTemplates = new PackagedTemplatesJobCatalogDecorator(catalog);
            JobTemplate template = catalogWithTemplates.getTemplate((URI)templateURIOpt.get());
            return template.getResolvedConfig(jobSpec.getConfig()).resolve();
        }
        return jobSpec.getConfig().resolve();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ResolvedJobSpec && super.equals(other) && this.originalJobSpec.equals(((ResolvedJobSpec)other).originalJobSpec);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.originalJobSpec.hashCode();
        return result;
    }

    public JobSpec getOriginalJobSpec() {
        return this.originalJobSpec;
    }
}

