/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Objects;
import java.net.URI;
import java.util.Properties;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.util.callbacks.Callback;

public interface SpecCatalogListener {
    public void onAddSpec(Spec var1);

    public void onDeleteSpec(URI var1, String var2, Properties var3);

    public void onUpdateSpec(Spec var1);

    public static class UpdateSpecCallback
    extends Callback<SpecCatalogListener, Void> {
        private final Spec _updatedSpec;

        public UpdateSpecCallback(Spec updatedSpec) {
            super(Objects.toStringHelper((String)"onUpdateSpec").add("updatedSpec", (Object)updatedSpec).toString());
            this._updatedSpec = updatedSpec;
        }

        public Void apply(SpecCatalogListener listener) {
            listener.onUpdateSpec(this._updatedSpec);
            return null;
        }
    }

    public static class DeleteSpecCallback
    extends Callback<SpecCatalogListener, Void> {
        private final URI _deletedSpecURI;
        private final String _deletedSpecVersion;
        private final Properties _headers;

        public DeleteSpecCallback(URI deletedSpecURI, String deletedSpecVersion, Properties headers) {
            super(Objects.toStringHelper((String)"onDeleteSpec").add("deletedSpecURI", (Object)deletedSpecURI).add("deletedSpecVersion", (Object)deletedSpecVersion).toString());
            this._deletedSpecURI = deletedSpecURI;
            this._deletedSpecVersion = deletedSpecVersion;
            this._headers = headers;
        }

        public Void apply(SpecCatalogListener listener) {
            listener.onDeleteSpec(this._deletedSpecURI, this._deletedSpecVersion, this._headers);
            return null;
        }
    }

    public static class AddSpecCallback
    extends Callback<SpecCatalogListener, Void> {
        private final Spec _addedSpec;

        public AddSpecCallback(Spec addedSpec) {
            super(Objects.toStringHelper((String)"onAddSpec").add("addedSpec", (Object)addedSpec).toString());
            this._addedSpec = addedSpec;
        }

        public Void apply(SpecCatalogListener listener) {
            listener.onAddSpec(this._addedSpec);
            return null;
        }
    }
}

