/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.codahale.metrics.Gauge;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.runtime.api.JobExecutionMonitor;
import org.apache.gobblin.runtime.api.JobSpec;

@Alpha
public interface JobExecutionLauncher
extends Instrumentable {
    public JobExecutionMonitor launchJob(JobSpec var1);

    public StandardMetrics getMetrics();

    public static class StandardMetrics {
        public static final String NUM_JOBS_LAUNCHED = "numJobsLaunched";
        public static final String NUM_JOBS_COMPLETED = "numJobsCompleted";
        public static final String NUM_JOBS_COMMITTED = "numJobsCommitted";
        public static final String NUM_JOBS_FAILED = "numJobsFailed";
        public static final String NUM_JOBS_CANCELLED = "numJobsCancelled";
        public static final String NUM_JOBS_RUNNING = "numJobsRunning";
        public static final String TIMER_FOR_COMPLETED_JOBS = "timeForCompletedJobs";
        public static final String TIMER_FOR_FAILED_JOBS = "timeForFailedJobs";
        public static final String TIMER_FOR_COMMITTED_JOBS = "timerForCommittedJobs";
        public static final String TIMER_BEFORE_JOB_SCHEDULING = "timerBeforeJobScheduling";
        public static final String TIMER_BEFORE_JOB_LAUNCHING = "timerBeforeJobLaunching";
        public static final String TIMER_BETWEEN_JOB_SCHEDULING_AND_LAUNCHING = "timerBetwenJobSchedulingAndLaunching";
        public static final String EXECUTOR_ACTIVE_COUNT = "executorActiveCount";
        public static final String EXECUTOR_MAX_POOL_SIZE = "executorMaximumPoolSize";
        public static final String EXECUTOR_POOL_SIZE = "executorPoolSize";
        public static final String EXECUTOR_CORE_POOL_SIZE = "executorCorePoolSize";
        public static final String EXECUTOR_QUEUE_SIZE = "executorQueueSize";
        public static final String TRACKING_EVENT_NAME = "JobExecutionLauncherEvent";
        public static final String JOB_EXECID_META = "jobExecId";
        public static final String JOB_LAUNCHED_OPERATION_TYPE = "JobLaunched";
        public static final String JOB_COMPLETED_OPERATION_TYPE = "JobCompleted";
        public static final String JOB_COMMITED_OPERATION_TYPE = "JobCommitted";
        public static final String JOB_FAILED_OPERATION_TYPE = "JobFailed";
        public static final String JOB_CANCELLED_OPERATION_TYPE = "JobCancelled";
        private final ContextAwareCounter numJobsLaunched;
        private final ContextAwareCounter numJobsCompleted;
        private final ContextAwareCounter numJobsCommitted;
        private final ContextAwareCounter numJobsFailed;
        private final ContextAwareCounter numJobsCancelled;
        private final ContextAwareGauge<Integer> numJobsRunning;

        public StandardMetrics(JobExecutionLauncher parent) {
            this.numJobsLaunched = parent.getMetricContext().contextAwareCounter(NUM_JOBS_LAUNCHED);
            this.numJobsCompleted = parent.getMetricContext().contextAwareCounter(NUM_JOBS_COMPLETED);
            this.numJobsCommitted = parent.getMetricContext().contextAwareCounter(NUM_JOBS_COMMITTED);
            this.numJobsFailed = parent.getMetricContext().contextAwareCounter(NUM_JOBS_FAILED);
            this.numJobsCancelled = parent.getMetricContext().contextAwareCounter(NUM_JOBS_CANCELLED);
            this.numJobsRunning = parent.getMetricContext().newContextAwareGauge(NUM_JOBS_RUNNING, (Gauge)new Gauge<Integer>(){

                public Integer getValue() {
                    return (int)(this.getNumJobsLaunched().getCount() - this.getNumJobsCompleted().getCount() - this.getNumJobsCancelled().getCount());
                }
            });
        }

        public ContextAwareCounter getNumJobsLaunched() {
            return this.numJobsLaunched;
        }

        public ContextAwareCounter getNumJobsCompleted() {
            return this.numJobsCompleted;
        }

        public ContextAwareCounter getNumJobsCommitted() {
            return this.numJobsCommitted;
        }

        public ContextAwareCounter getNumJobsFailed() {
            return this.numJobsFailed;
        }

        public ContextAwareCounter getNumJobsCancelled() {
            return this.numJobsCancelled;
        }

        public ContextAwareGauge<Integer> getNumJobsRunning() {
            return this.numJobsRunning;
        }
    }
}

