/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.instance;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.SharedResourcesBrokerImpl;
import org.apache.gobblin.broker.SimpleScope;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.GobblinInstanceLauncher;
import org.apache.gobblin.runtime.api.GobblinInstancePlugin;
import org.apache.gobblin.runtime.api.GobblinInstancePluginFactory;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobExecutionLauncher;
import org.apache.gobblin.runtime.api.JobSpecScheduler;
import org.apache.gobblin.runtime.instance.DefaultGobblinInstanceDriverImpl;
import org.apache.gobblin.runtime.job_catalog.FSJobCatalog;
import org.apache.gobblin.runtime.job_catalog.ImmutableFSJobCatalog;
import org.apache.gobblin.runtime.job_catalog.InMemoryJobCatalog;
import org.apache.gobblin.runtime.job_exec.JobLauncherExecutionDriver;
import org.apache.gobblin.runtime.plugins.email.EmailNotificationPlugin;
import org.apache.gobblin.runtime.scheduler.ImmediateJobSpecScheduler;
import org.apache.gobblin.runtime.scheduler.QuartzJobSpecScheduler;
import org.apache.gobblin.runtime.std.DefaultConfigurableImpl;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGobblinInstanceDriver
extends DefaultGobblinInstanceDriverImpl {
    public static final String INSTANCE_CFG_PREFIX = "gobblin.instance";
    public static final String PLUGINS_KEY = "plugins";
    public static final String PLUGINS_FULL_KEY = "gobblin.instance.plugins";
    private ServiceManager _subservices;
    private final List<GobblinInstancePlugin> _plugins;

    protected StandardGobblinInstanceDriver(String instanceName, Configurable sysConfig, JobCatalog jobCatalog, JobSpecScheduler jobScheduler, JobExecutionLauncher jobLauncher, Optional<MetricContext> instanceMetricContext, Optional<Logger> log, List<GobblinInstancePluginFactory> plugins, SharedResourcesBroker<GobblinScopeTypes> instanceBroker) {
        super(instanceName, sysConfig, jobCatalog, jobScheduler, jobLauncher, instanceMetricContext, log, instanceBroker);
        ArrayList<Service> componentServices = new ArrayList<Service>();
        this.checkComponentService(this.getJobCatalog(), componentServices);
        this.checkComponentService(this.getJobScheduler(), componentServices);
        this.checkComponentService(this.getJobLauncher(), componentServices);
        this._plugins = this.createPlugins(plugins, componentServices);
        if (componentServices.size() > 0) {
            this._subservices = new ServiceManager(componentServices);
        }
    }

    private List<GobblinInstancePlugin> createPlugins(List<GobblinInstancePluginFactory> plugins, List<Service> componentServices) {
        ArrayList<GobblinInstancePlugin> res = new ArrayList<GobblinInstancePlugin>();
        for (GobblinInstancePluginFactory pluginFactory : plugins) {
            Optional<GobblinInstancePlugin> plugin = StandardGobblinInstanceDriver.createPlugin(this, pluginFactory, componentServices);
            if (!plugin.isPresent()) continue;
            res.add((GobblinInstancePlugin)plugin.get());
        }
        return res;
    }

    static Optional<GobblinInstancePlugin> createPlugin(StandardGobblinInstanceDriver instance, GobblinInstancePluginFactory pluginFactory, List<Service> componentServices) {
        instance.getLog().info("Instantiating a plugin of type: " + pluginFactory);
        try {
            GobblinInstancePlugin plugin = pluginFactory.createPlugin(instance);
            componentServices.add(plugin);
            instance.getLog().info("Instantiated plugin: " + plugin);
            return Optional.of((Object)plugin);
        }
        catch (RuntimeException e) {
            instance.getLog().warn("Failed to create plugin: " + e, (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    protected void startUp() throws Exception {
        this.getLog().info("Starting driver ...");
        if (null != this._subservices) {
            this.getLog().info("Starting subservices. Timeout is {} ms", (Object)this.getInstanceCfg().getStartTimeoutMs());
            long startTime = System.currentTimeMillis();
            this._subservices.startAsync();
            this._subservices.awaitHealthy(this.getInstanceCfg().getStartTimeoutMs(), TimeUnit.MILLISECONDS);
            this.getLog().info("All subservices have been started. Time waited is {} ms", (Object)(System.currentTimeMillis() - startTime));
        } else {
            this.getLog().info("No subservices found.");
        }
        super.startUp();
    }

    private void checkComponentService(Object component, List<Service> componentServices) {
        if (component instanceof Service) {
            componentServices.add((Service)component);
        }
    }

    @Override
    protected void shutDown() throws Exception {
        this.getLog().info("Shutting down driver ...");
        super.shutDown();
        if (null != this._subservices) {
            this.getLog().info("Shutting down subservices ...");
            this._subservices.stopAsync();
            this._subservices.awaitStopped(this.getInstanceCfg().getShutdownTimeoutMs(), TimeUnit.MILLISECONDS);
            this.getLog().info("All subservices have been shutdown.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<GobblinInstancePlugin> getPlugins() {
        return this._plugins;
    }

    public static class Builder
    implements GobblinInstanceEnvironment {
        private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
        private Optional<GobblinInstanceEnvironment> _instanceEnv = Optional.absent();
        private Optional<String> _instanceName = Optional.absent();
        private Optional<Logger> _log = Optional.absent();
        private Optional<JobCatalog> _jobCatalog = Optional.absent();
        private Optional<JobSpecScheduler> _jobScheduler = Optional.absent();
        private Optional<JobExecutionLauncher> _jobLauncher = Optional.absent();
        private Optional<MetricContext> _metricContext = Optional.absent();
        private Optional<Boolean> _instrumentationEnabled = Optional.absent();
        private Optional<SharedResourcesBroker<GobblinScopeTypes>> _instanceBroker = Optional.absent();
        private List<GobblinInstancePluginFactory> _plugins = new ArrayList<GobblinInstancePluginFactory>();
        private final ClassAliasResolver<GobblinInstancePluginFactory> _aliasResolver = new ClassAliasResolver(GobblinInstancePluginFactory.class);

        public Builder(Optional<GobblinInstanceEnvironment> instanceLauncher) {
            this._instanceEnv = instanceLauncher;
        }

        public Builder() {
        }

        public Builder(GobblinInstanceLauncher instanceLauncher) {
            this();
            this.withInstanceEnvironment(instanceLauncher);
        }

        public Builder withInstanceEnvironment(GobblinInstanceEnvironment instanceLauncher) {
            Preconditions.checkNotNull((Object)instanceLauncher);
            this._instanceEnv = Optional.of((Object)instanceLauncher);
            return this;
        }

        public Optional<GobblinInstanceEnvironment> getInstanceEnvironment() {
            return this._instanceEnv;
        }

        public String getDefaultInstanceName() {
            if (this._instanceEnv.isPresent()) {
                return ((GobblinInstanceEnvironment)this._instanceEnv.get()).getInstanceName();
            }
            return StandardGobblinInstanceDriver.class.getName() + "-" + INSTANCE_COUNTER.getAndIncrement();
        }

        @Override
        public String getInstanceName() {
            if (!this._instanceName.isPresent()) {
                this._instanceName = Optional.of((Object)this.getDefaultInstanceName());
            }
            return (String)this._instanceName.get();
        }

        public Builder withInstanceName(String instanceName) {
            this._instanceName = Optional.of((Object)instanceName);
            return this;
        }

        public Logger getDefaultLog() {
            return this._instanceEnv.isPresent() ? ((GobblinInstanceEnvironment)this._instanceEnv.get()).getLog() : LoggerFactory.getLogger((String)this.getInstanceName());
        }

        @Override
        public Logger getLog() {
            if (!this._log.isPresent()) {
                this._log = Optional.of((Object)this.getDefaultLog());
            }
            return (Logger)this._log.get();
        }

        public Builder withLog(Logger log) {
            this._log = Optional.of((Object)log);
            return this;
        }

        public JobCatalog getDefaultJobCatalog() {
            return new InMemoryJobCatalog(this);
        }

        public JobCatalog getJobCatalog() {
            if (!this._jobCatalog.isPresent()) {
                this._jobCatalog = Optional.of((Object)this.getDefaultJobCatalog());
            }
            return (JobCatalog)this._jobCatalog.get();
        }

        public Builder withJobCatalog(JobCatalog jobCatalog) {
            this._jobCatalog = Optional.of((Object)jobCatalog);
            return this;
        }

        public Builder withInMemoryJobCatalog() {
            return this.withJobCatalog(new InMemoryJobCatalog(this));
        }

        public Builder withFSJobCatalog() {
            try {
                return this.withJobCatalog(new FSJobCatalog(this));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create FS Job Catalog: " + e, e);
            }
        }

        public Builder withImmutableFSJobCatalog() {
            try {
                return this.withJobCatalog(new ImmutableFSJobCatalog(this));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create FS Job Catalog: " + e, e);
            }
        }

        public JobSpecScheduler getDefaultJobScheduler() {
            return new ImmediateJobSpecScheduler((Optional<Logger>)Optional.of((Object)this.getLog()));
        }

        public JobSpecScheduler getJobScheduler() {
            if (!this._jobScheduler.isPresent()) {
                this._jobScheduler = Optional.of((Object)this.getDefaultJobScheduler());
            }
            return (JobSpecScheduler)this._jobScheduler.get();
        }

        public Builder withJobScheduler(JobSpecScheduler jobScheduler) {
            this._jobScheduler = Optional.of((Object)jobScheduler);
            return this;
        }

        public Builder withImmediateJobScheduler() {
            return this.withJobScheduler(new ImmediateJobSpecScheduler((Optional<Logger>)Optional.of((Object)this.getLog())));
        }

        public Builder withQuartzJobScheduler() {
            return this.withJobScheduler(new QuartzJobSpecScheduler(this));
        }

        public JobExecutionLauncher getDefaultJobLauncher() {
            JobLauncherExecutionDriver.Launcher res = new JobLauncherExecutionDriver.Launcher().withGobblinInstanceEnvironment(this);
            return res;
        }

        public JobExecutionLauncher getJobLauncher() {
            if (!this._jobLauncher.isPresent()) {
                this._jobLauncher = Optional.of((Object)this.getDefaultJobLauncher());
            }
            return (JobExecutionLauncher)this._jobLauncher.get();
        }

        public Builder withJobLauncher(JobExecutionLauncher jobLauncher) {
            this._jobLauncher = Optional.of((Object)jobLauncher);
            return this;
        }

        public Builder withMetricContext(MetricContext instanceMetricContext) {
            this._metricContext = Optional.of((Object)instanceMetricContext);
            return this;
        }

        public MetricContext getMetricContext() {
            if (!this._metricContext.isPresent()) {
                this._metricContext = Optional.of((Object)this.getDefaultMetricContext());
            }
            return (MetricContext)this._metricContext.get();
        }

        public MetricContext getDefaultMetricContext() {
            State fakeState = new State(this.getSysConfig().getConfigAsProperties());
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag("instanceName", (Object)this.getInstanceName()));
            MetricContext res = Instrumented.getMetricContext((State)fakeState, StandardGobblinInstanceDriver.class, tags);
            return res;
        }

        public Builder withInstanceBroker(SharedResourcesBroker<GobblinScopeTypes> broker) {
            this._instanceBroker = Optional.of(broker);
            return this;
        }

        @Override
        public SharedResourcesBroker<GobblinScopeTypes> getInstanceBroker() {
            if (!this._instanceBroker.isPresent()) {
                this._instanceBroker = Optional.of(this.getDefaultInstanceBroker());
            }
            return (SharedResourcesBroker)this._instanceBroker.get();
        }

        public SharedResourcesBroker<GobblinScopeTypes> getDefaultInstanceBroker() {
            SharedResourcesBrokerImpl globalBroker = SharedResourcesBrokerFactory.createDefaultTopLevelBroker((Config)this.getSysConfig().getConfig(), (ScopeInstance)GobblinScopeTypes.GLOBAL.defaultScopeInstance());
            return globalBroker.newSubscopedBuilder((ScopeInstance)new SimpleScope((ScopeType)GobblinScopeTypes.INSTANCE, this.getInstanceName())).build();
        }

        public StandardGobblinInstanceDriver build() {
            Configurable sysConfig = this.getSysConfig();
            return new StandardGobblinInstanceDriver(this.getInstanceName(), sysConfig, this.getJobCatalog(), this.getJobScheduler(), this.getJobLauncher(), (Optional<MetricContext>)(this.isInstrumentationEnabled() ? Optional.of((Object)this.getMetricContext()) : Optional.absent()), (Optional<Logger>)Optional.of((Object)this.getLog()), this.getPlugins(), this.getInstanceBroker());
        }

        @Override
        public Configurable getSysConfig() {
            return this._instanceEnv.isPresent() ? ((GobblinInstanceEnvironment)this._instanceEnv.get()).getSysConfig() : DefaultConfigurableImpl.createFromConfig(ConfigFactory.load());
        }

        public Builder withInstrumentationEnabled(boolean enabled) {
            this._instrumentationEnabled = Optional.of((Object)enabled);
            return this;
        }

        public boolean getDefaultInstrumentationEnabled() {
            return GobblinMetrics.isEnabled((Config)this.getSysConfig().getConfig());
        }

        public boolean isInstrumentationEnabled() {
            if (!this._instrumentationEnabled.isPresent()) {
                this._instrumentationEnabled = Optional.of((Object)this.getDefaultInstrumentationEnabled());
            }
            return (Boolean)this._instrumentationEnabled.get();
        }

        public List<Tag<?>> generateTags(State state) {
            return Collections.emptyList();
        }

        public void switchMetricContext(List<Tag<?>> tags) {
            throw new UnsupportedOperationException();
        }

        public void switchMetricContext(MetricContext context) {
            throw new UnsupportedOperationException();
        }

        public List<GobblinInstancePluginFactory> getDefaultPlugins() {
            List pluginNames = ConfigUtils.getStringList((Config)this.getSysConfig().getConfig(), (String)StandardGobblinInstanceDriver.PLUGINS_FULL_KEY);
            ArrayList pluginFactories = Lists.newArrayList();
            if (!ConfigUtils.getBoolean((Config)this.getSysConfig().getConfig(), (String)"gobblin.instance.emailNotifications.disabled", (boolean)false)) {
                pluginFactories.add(new EmailNotificationPlugin.Factory());
            }
            pluginFactories.addAll(Lists.transform((List)pluginNames, (Function)new Function<String, GobblinInstancePluginFactory>(){

                public GobblinInstancePluginFactory apply(String input) {
                    try {
                        Class factoryClass = _aliasResolver.resolveClass(input);
                        return (GobblinInstancePluginFactory)factoryClass.newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Unable to instantiate plugin factory " + input + ": " + e, e);
                    }
                }
            }));
            return pluginFactories;
        }

        public List<GobblinInstancePluginFactory> getPlugins() {
            ArrayList<GobblinInstancePluginFactory> res = new ArrayList<GobblinInstancePluginFactory>(this.getDefaultPlugins());
            res.addAll(this._plugins);
            return res;
        }

        public Builder addPlugin(GobblinInstancePluginFactory pluginFactory) {
            this._plugins.add(pluginFactory);
            return this;
        }
    }
}

