/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.CustomCodahaleReporterFactory;
import org.apache.gobblin.metrics.CustomReporterFactory;
import org.apache.gobblin.metrics.GobblinMetricsRegistry;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.MetricReporterException;
import org.apache.gobblin.metrics.MultiReporterException;
import org.apache.gobblin.metrics.ReporterSinkType;
import org.apache.gobblin.metrics.ReporterType;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.graphite.GraphiteConnectionType;
import org.apache.gobblin.metrics.graphite.GraphiteEventReporter;
import org.apache.gobblin.metrics.graphite.GraphiteReporter;
import org.apache.gobblin.metrics.influxdb.InfluxDBConnectionType;
import org.apache.gobblin.metrics.influxdb.InfluxDBEventReporter;
import org.apache.gobblin.metrics.influxdb.InfluxDBReporter;
import org.apache.gobblin.metrics.reporter.FileFailureEventReporter;
import org.apache.gobblin.metrics.reporter.OutputStreamEventReporter;
import org.apache.gobblin.metrics.reporter.OutputStreamReporter;
import org.apache.gobblin.metrics.reporter.ScheduledReporter;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.PropertiesUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinMetrics {
    public static final String METRICS_ID_PREFIX = "gobblin.metrics.";
    public static final String METRICS_STATE_CUSTOM_TAGS = "metrics.state.custom.tags";
    protected static final GobblinMetricsRegistry GOBBLIN_METRICS_REGISTRY = GobblinMetricsRegistry.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinMetrics.class);
    protected final String id;
    protected final MetricContext metricContext;
    protected final Closer codahaleReportersCloser = Closer.create();
    private Optional<JmxReporter> jmxReporter = Optional.absent();
    private final List<com.codahale.metrics.ScheduledReporter> codahaleScheduledReporters = Lists.newArrayList();
    private volatile boolean metricsReportingStarted = false;

    public static boolean isEnabled(Properties properties) {
        return PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.enabled", (String)ConfigurationKeys.DEFAULT_METRICS_ENABLED);
    }

    public static boolean isEnabled(State state) {
        return Boolean.valueOf(state.getProp("metrics.enabled", ConfigurationKeys.DEFAULT_METRICS_ENABLED));
    }

    public static boolean isEnabled(Config cfg) {
        return cfg.hasPath("metrics.enabled") ? cfg.getBoolean("metrics.enabled") : Boolean.parseBoolean(ConfigurationKeys.DEFAULT_METRICS_ENABLED);
    }

    public static GobblinMetrics get(String id) {
        return GobblinMetrics.get(id, null);
    }

    public static GobblinMetrics get(String id, MetricContext parentContext) {
        return GobblinMetrics.get(id, parentContext, Lists.newArrayList());
    }

    public static GobblinMetrics get(final String id, final MetricContext parentContext, final List<Tag<?>> tags) {
        return GOBBLIN_METRICS_REGISTRY.getOrCreate(id, (Callable<? extends GobblinMetrics>)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new GobblinMetrics(id, parentContext, tags);
            }
        });
    }

    public static void remove(String id) {
        GOBBLIN_METRICS_REGISTRY.remove(id);
    }

    public static void addCustomTagToState(State state, List<? extends Tag<?>> tags) {
        for (Tag<?> tag : tags) {
            state.appendToListProp(METRICS_STATE_CUSTOM_TAGS, tag.toString());
        }
    }

    public static void addCustomTagToState(State state, Tag<?> tag) {
        state.appendToListProp(METRICS_STATE_CUSTOM_TAGS, tag.toString());
    }

    public static void addCustomTagsToProperties(Properties properties, List<Tag<?>> tags) {
        for (Tag<?> tag : tags) {
            GobblinMetrics.addCustomTagToProperties(properties, tag);
        }
    }

    public static void addCustomTagToProperties(Properties properties, Tag<?> tag) {
        State state = new State(properties);
        GobblinMetrics.addCustomTagToState(state, tag);
    }

    public static List<Tag<?>> getCustomTagsFromState(State state) {
        ArrayList tags = Lists.newArrayList();
        for (String tagKeyValue : state.getPropAsList(METRICS_STATE_CUSTOM_TAGS, "")) {
            Tag tag = Tag.fromString((String)tagKeyValue);
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    protected GobblinMetrics(String id, MetricContext parentContext, List<Tag<?>> tags) {
        this.id = id;
        this.metricContext = parentContext == null ? new MetricContext.Builder(id).addTags(tags).build() : parentContext.childBuilder(id).addTags(tags).build();
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public Meter getMeter(String prefix, String ... suffixes) {
        return this.metricContext.meter(MetricRegistry.name((String)prefix, (String[])suffixes));
    }

    public Counter getCounter(String prefix, String ... suffixes) {
        return this.metricContext.counter(MetricRegistry.name((String)prefix, (String[])suffixes));
    }

    public Histogram getHistogram(String prefix, String ... suffixes) {
        return this.metricContext.histogram(MetricRegistry.name((String)prefix, (String[])suffixes));
    }

    public Timer getTimer(String prefix, String ... suffixes) {
        return this.metricContext.timer(MetricRegistry.name((String)prefix, (String[])suffixes));
    }

    public void startMetricReportingWithFileSuffix(State state, String metricsFileSuffix) throws MultiReporterException {
        Properties metricsReportingProps = new Properties();
        metricsReportingProps.putAll((Map<?, ?>)state.getProperties());
        String oldMetricsFileSuffix = state.getProp("metrics.reporting.file.suffix", "");
        oldMetricsFileSuffix = Strings.isNullOrEmpty((String)oldMetricsFileSuffix) ? metricsFileSuffix : oldMetricsFileSuffix + "." + metricsFileSuffix;
        metricsReportingProps.setProperty("metrics.reporting.file.suffix", oldMetricsFileSuffix);
        this.startMetricReporting(metricsReportingProps);
    }

    public void startMetricReporting(Configuration configuration) throws MultiReporterException {
        Properties props = new Properties();
        for (Map.Entry entry : configuration) {
            props.put(entry.getKey(), entry.getValue());
        }
        this.startMetricReporting(props);
    }

    public void startMetricReporting(Properties properties) throws MultiReporterException {
        if (this.metricsReportingStarted) {
            LOGGER.warn("Metric reporting has already started");
            return;
        }
        TimeUnit reportTimeUnit = TimeUnit.MILLISECONDS;
        long reportInterval = Long.parseLong(properties.getProperty("metrics.report.interval", ConfigurationKeys.DEFAULT_METRICS_REPORT_INTERVAL));
        ScheduledReporter.setReportingInterval((Properties)properties, (long)reportInterval, (TimeUnit)reportTimeUnit);
        long startTime = System.currentTimeMillis();
        ArrayList reporterExceptions = Lists.newArrayList();
        try {
            for (ReporterSinkType sinkType : ReporterSinkType.values()) {
                if (sinkType.equals((Object)ReporterSinkType.CUSTOM)) {
                    this.buildCustomMetricReporters(properties, reporterExceptions);
                    continue;
                }
                try {
                    this.buildReporter(properties, sinkType);
                }
                catch (MultiReporterException e) {
                    reporterExceptions.addAll(e.getExceptions());
                }
            }
            RootMetricContext.get().startReporting();
            for (com.codahale.metrics.ScheduledReporter scheduledReporter : this.codahaleScheduledReporters) {
                scheduledReporter.start(reportInterval, reportTimeUnit);
            }
        }
        catch (Exception e) {
            LOGGER.error("Metrics reporting cannot be started due to {}", (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw e;
        }
        this.metricsReportingStarted = true;
        LOGGER.info("Metrics reporting has been started in {} ms: GobblinMetrics {}", (Object)(System.currentTimeMillis() - startTime), (Object)this.toString());
        if (!reporterExceptions.isEmpty()) {
            throw new MultiReporterException("Could not create one or more reporters", (List)reporterExceptions);
        }
    }

    private void buildReporter(Properties properties, ReporterSinkType sinkType) throws MultiReporterException {
        switch (sinkType) {
            case JMX: {
                this.buildJmxMetricReporter(properties);
                break;
            }
            case FILE: {
                this.buildFileMetricReporter(properties);
                break;
            }
            case KAFKA: {
                this.buildKafkaMetricReporter(properties);
                break;
            }
            case GRAPHITE: {
                this.buildGraphiteMetricReporter(properties);
                break;
            }
            case INFLUXDB: {
                this.buildInfluxDBMetricReporter(properties);
                break;
            }
            case FILE_FAILURE: {
                this.buildFileFailureEventReporter(properties);
                break;
            }
            default: {
                LOGGER.error("Unknown reporter sink type: {}", (Object)sinkType.name());
            }
        }
    }

    public void stopMetricsReporting() {
        LOGGER.info("Metrics reporting will be stopped: GobblinMetrics {}", (Object)this.toString());
        if (!this.metricsReportingStarted) {
            LOGGER.warn("Metric reporting has not started yet");
            return;
        }
        if (this.jmxReporter.isPresent()) {
            ((JmxReporter)this.jmxReporter.get()).stop();
        }
        RootMetricContext.get().stopReporting();
        for (com.codahale.metrics.ScheduledReporter scheduledReporter : this.codahaleScheduledReporters) {
            scheduledReporter.report();
        }
        try {
            this.codahaleReportersCloser.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to close metric output stream for job " + this.id, (Throwable)ioe);
        }
        catch (Exception e) {
            LOGGER.error("Failed to close metric output stream for job {} due to {}", (Object)this.id, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw e;
        }
        this.metricsReportingStarted = false;
        GobblinMetrics.remove(this.id);
        LOGGER.info("Metrics reporting stopped successfully");
    }

    private void buildFileMetricReporter(Properties properties) throws MultiReporterException {
        if (!Boolean.valueOf(properties.getProperty("metrics.reporting.file.enabled", ConfigurationKeys.DEFAULT_METRICS_REPORTING_FILE_ENABLED)).booleanValue()) {
            return;
        }
        LOGGER.info("Reporting metrics to log files");
        if (!properties.containsKey("metrics.log.dir")) {
            MetricReporterException e = new MetricReporterException("Not reporting metrics to log files because metrics.log.dir is undefined", ReporterType.METRIC, ReporterSinkType.FILE);
            throw new MultiReporterException("Failed to create file metric reporter", (List)Lists.newArrayList((Object[])new MetricReporterException[]{e}));
        }
        try {
            String fsUri = properties.getProperty("fs.uri", "file:///");
            FileSystem fs = FileSystem.get((URI)URI.create(fsUri), (Configuration)new Configuration());
            Path metricsLogDir = new Path(properties.getProperty("metrics.log.dir"), this.getName());
            if (!fs.exists(metricsLogDir) && !fs.mkdirs(metricsLogDir)) {
                throw new MetricReporterException("Failed to create metric log directory for metrics " + this.getName(), ReporterType.METRIC, ReporterSinkType.FILE);
            }
            String metricsFileSuffix = properties.getProperty("metrics.reporting.file.suffix", "");
            if (!Strings.isNullOrEmpty((String)metricsFileSuffix) && !metricsFileSuffix.startsWith(".")) {
                metricsFileSuffix = "." + metricsFileSuffix;
            }
            Path metricLogFile = new Path(metricsLogDir, this.id + metricsFileSuffix + ".metrics.log");
            boolean append = false;
            if (fs.exists(metricLogFile)) {
                LOGGER.info(String.format("Metric log file %s already exists, appending to it", metricLogFile));
                append = true;
            }
            FSDataOutputStream output = append ? fs.append(metricLogFile) : fs.create(metricLogFile, true);
            ((OutputStreamReporter.BuilderImpl)OutputStreamReporter.Factory.newBuilder().outputTo((OutputStream)output)).build(properties);
            this.codahaleScheduledReporters.add((com.codahale.metrics.ScheduledReporter)this.codahaleReportersCloser.register((Closeable)OutputStreamEventReporter.forContext((MetricContext)RootMetricContext.get()).outputTo((OutputStream)output).build()));
            LOGGER.info("Will start reporting metrics to directory " + metricsLogDir);
        }
        catch (IOException ioe) {
            MetricReporterException e = new MetricReporterException("Failed to build file metric reporter for job " + this.id, (Throwable)ioe, ReporterType.METRIC, ReporterSinkType.FILE);
            throw new MultiReporterException("Failed to create file metric reporter", (List)Lists.newArrayList((Object[])new MetricReporterException[]{e}));
        }
    }

    private void buildFileFailureEventReporter(Properties properties) throws MultiReporterException {
        if (!Boolean.valueOf(properties.getProperty("failure.reporting.file.enabled", ConfigurationKeys.DEFAULT_FAILURE_REPORTING_FILE_ENABLED)).booleanValue() || !properties.containsKey("failure.log.dir")) {
            return;
        }
        LOGGER.info("Reporting failure to log files");
        try {
            String fsUri = properties.getProperty("fs.uri", "file:///");
            FileSystem fs = FileSystem.get((URI)URI.create(fsUri), (Configuration)new Configuration());
            Path failureLogDir = new Path(properties.getProperty("failure.log.dir"), this.getName());
            if (!fs.exists(failureLogDir) && !fs.mkdirs(failureLogDir)) {
                throw new MetricReporterException("Failed to create failure log directory for metrics " + this.getName(), ReporterType.EVENT, ReporterSinkType.FILE);
            }
            String metricsFileSuffix = properties.getProperty("metrics.reporting.file.suffix", "");
            if (!Strings.isNullOrEmpty((String)metricsFileSuffix) && !metricsFileSuffix.startsWith(".")) {
                metricsFileSuffix = "." + metricsFileSuffix;
            }
            Path failureLogFile = new Path(failureLogDir, this.id + metricsFileSuffix + ".failure.log");
            this.codahaleScheduledReporters.add((com.codahale.metrics.ScheduledReporter)this.codahaleReportersCloser.register((Closeable)new FileFailureEventReporter((MetricContext)RootMetricContext.get(), fs, failureLogFile)));
            LOGGER.info("Will start reporting failure to directory " + failureLogDir);
        }
        catch (IOException ioe) {
            MetricReporterException e = new MetricReporterException("Failed to build file failure event reporter for job " + this.id, (Throwable)ioe, ReporterType.EVENT, ReporterSinkType.FILE);
            throw new MultiReporterException("Failed to create failure file event reporter", (List)Lists.newArrayList((Object[])new MetricReporterException[]{e}));
        }
    }

    private void buildJmxMetricReporter(Properties properties) {
        if (!Boolean.valueOf(properties.getProperty("metrics.reporting.jmx.enabled", ConfigurationKeys.DEFAULT_METRICS_REPORTING_JMX_ENABLED)).booleanValue()) {
            return;
        }
        LOGGER.info("Reporting metrics to JMX");
        this.jmxReporter = Optional.of((Object)this.codahaleReportersCloser.register((Closeable)JmxReporter.forRegistry((MetricRegistry)RootMetricContext.get()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build()));
    }

    private void buildKafkaMetricReporter(Properties properties) throws MultiReporterException {
        ArrayList reporterExceptions = Lists.newArrayList();
        if (!Boolean.valueOf(properties.getProperty("metrics.reporting.kafka.enabled", ConfigurationKeys.DEFAULT_METRICS_REPORTING_KAFKA_ENABLED)).booleanValue()) {
            return;
        }
        try {
            this.buildScheduledReporter(properties, "org.apache.gobblin.metrics.kafka.KafkaMetricReporterFactory");
        }
        catch (MetricReporterException e) {
            reporterExceptions.add(e);
        }
        try {
            this.buildScheduledReporter(properties, "org.apache.gobblin.metrics.kafka.KafkaEventReporterFactory");
        }
        catch (MetricReporterException e) {
            reporterExceptions.add(e);
        }
        if (!reporterExceptions.isEmpty()) {
            throw new MultiReporterException("Failed to start one or more Kafka reporters", (List)reporterExceptions);
        }
    }

    private void buildGraphiteMetricReporter(Properties properties) throws MultiReporterException {
        GraphiteConnectionType connectionType;
        boolean eventsEnabled;
        ArrayList reporterExceptionList = Lists.newArrayList();
        boolean metricsEnabled = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.reporting.graphite.metrics.enabled", (String)ConfigurationKeys.DEFAULT_METRICS_REPORTING_GRAPHITE_METRICS_ENABLED);
        if (metricsEnabled) {
            LOGGER.info("Reporting metrics to Graphite");
        }
        if (eventsEnabled = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.reporting.graphite.events.enabled", (String)ConfigurationKeys.DEFAULT_METRICS_REPORTING_GRAPHITE_EVENTS_ENABLED)) {
            LOGGER.info("Reporting events to Graphite");
        }
        if (!metricsEnabled && !eventsEnabled) {
            return;
        }
        try {
            Preconditions.checkArgument((boolean)properties.containsKey("metrics.reporting.graphite.hostname"), (Object)"Graphite hostname is missing.");
        }
        catch (IllegalArgumentException exception) {
            reporterExceptionList.add(new MetricReporterException("Missing Graphite configuration(s).", (Throwable)exception, ReporterType.METRIC_EVENT, ReporterSinkType.GRAPHITE));
            throw new MultiReporterException("Failed to start one or more Graphite reporters", (List)reporterExceptionList);
        }
        String hostname = properties.getProperty("metrics.reporting.graphite.hostname");
        int port = Integer.parseInt(properties.getProperty("metrics.reporting.graphite.port", "2003"));
        String type = properties.getProperty("metrics.reporting.graphite.sending.type", "TCP").toUpperCase();
        String prefix = properties.getProperty("metrics.reporting.graphite.prefix", "");
        try {
            connectionType = GraphiteConnectionType.valueOf((String)type);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn("Graphite Reporter connection type " + type + " not recognized. Will use TCP for sending.", (Throwable)exception);
            connectionType = GraphiteConnectionType.TCP;
        }
        if (metricsEnabled) {
            try {
                ((GraphiteReporter.BuilderImpl)((GraphiteReporter.BuilderImpl)((GraphiteReporter.BuilderImpl)((GraphiteReporter.BuilderImpl)GraphiteReporter.Factory.newBuilder().withConnectionType(connectionType)).withConnection(hostname, port)).withMetricContextName(this.metricContext.getName())).withMetricsPrefix(prefix)).build(properties);
            }
            catch (IOException e) {
                reporterExceptionList.add(new MetricReporterException("Failed to create Graphite metrics reporter.", (Throwable)e, ReporterType.METRIC, ReporterSinkType.GRAPHITE));
            }
        }
        if (eventsEnabled) {
            boolean emitValueAsKey = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.reporting.graphite.events.value.as.key", (String)ConfigurationKeys.DEFAULT_METRICS_REPORTING_GRAPHITE_EVENTS_VALUE_AS_KEY);
            String eventsPortProp = properties.getProperty("metrics.reporting.graphite.events.port");
            int eventsPort = eventsPortProp == null ? (metricsEnabled ? port : Integer.parseInt("metrics.reporting.graphite.port")) : Integer.parseInt(eventsPortProp);
            try {
                GraphiteEventReporter eventReporter = ((GraphiteEventReporter.BuilderImpl)((GraphiteEventReporter.BuilderImpl)((GraphiteEventReporter.BuilderImpl)((GraphiteEventReporter.BuilderImpl)GraphiteEventReporter.Factory.forContext((MetricContext)RootMetricContext.get()).withConnectionType(connectionType)).withConnection(hostname, eventsPort)).withPrefix(prefix)).withEmitValueAsKey(emitValueAsKey)).build();
                this.codahaleScheduledReporters.add((com.codahale.metrics.ScheduledReporter)this.codahaleReportersCloser.register((Closeable)eventReporter));
            }
            catch (IOException e) {
                reporterExceptionList.add(new MetricReporterException("Failed to create Graphite event reporter.", (Throwable)e, ReporterType.EVENT, ReporterSinkType.GRAPHITE));
            }
        }
        if (!reporterExceptionList.isEmpty()) {
            throw new MultiReporterException("Failed to create one or more Graphite Reporters", (List)reporterExceptionList);
        }
    }

    private void buildInfluxDBMetricReporter(Properties properties) throws MultiReporterException {
        InfluxDBConnectionType connectionType;
        boolean eventsEnabled;
        ArrayList reporterExceptionList = Lists.newArrayList();
        boolean metricsEnabled = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.reporting.influxdb.metrics.enabled", (String)ConfigurationKeys.DEFAULT_METRICS_REPORTING_INFLUXDB_METRICS_ENABLED);
        if (metricsEnabled) {
            LOGGER.info("Reporting metrics to InfluxDB");
        }
        if (eventsEnabled = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)"metrics.reporting.influxdb.events.enabled", (String)ConfigurationKeys.DEFAULT_METRICS_REPORTING_INFLUXDB_EVENTS_ENABLED)) {
            LOGGER.info("Reporting events to InfluxDB");
        }
        if (!metricsEnabled && !eventsEnabled) {
            return;
        }
        try {
            Preconditions.checkArgument((boolean)properties.containsKey("metrics.reporting.influxdb.database"), (Object)"InfluxDB database name is missing.");
        }
        catch (IllegalArgumentException exception) {
            reporterExceptionList.add(new MetricReporterException("Missing InfluxDB configuration(s)", (Throwable)exception, ReporterType.METRIC_EVENT, ReporterSinkType.INFLUXDB));
            throw new MultiReporterException("Failed to start one or more InfluxDB reporters", (List)reporterExceptionList);
        }
        String url = properties.getProperty("metrics.reporting.influxdb.url");
        String username = properties.getProperty("metrics.reporting.influxdb.user");
        String password = PasswordManager.getInstance((Properties)properties).readPassword(properties.getProperty("metrics.reporting.influxdb.password"));
        String database = properties.getProperty("metrics.reporting.influxdb.database");
        String type = properties.getProperty("metrics.reporting.influxdb.sending.type", "TCP").toUpperCase();
        try {
            connectionType = InfluxDBConnectionType.valueOf((String)type);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn("InfluxDB Reporter connection type " + type + " not recognized. Will use TCP for sending.", (Throwable)exception);
            connectionType = InfluxDBConnectionType.TCP;
        }
        if (metricsEnabled) {
            try {
                ((InfluxDBReporter.BuilderImpl)((InfluxDBReporter.BuilderImpl)((InfluxDBReporter.BuilderImpl)InfluxDBReporter.Factory.newBuilder().withConnectionType(connectionType)).withConnection(url, username, password, database)).withMetricContextName(this.metricContext.getName())).build(properties);
            }
            catch (IOException e) {
                reporterExceptionList.add(new MetricReporterException("Failed to create InfluxDB metrics reporter.", (Throwable)e, ReporterType.METRIC, ReporterSinkType.INFLUXDB));
            }
        }
        if (eventsEnabled) {
            String eventsDbProp = properties.getProperty("metrics.reporting.influxdb.events.database");
            String eventsDatabase = eventsDbProp == null ? (metricsEnabled ? database : null) : eventsDbProp;
            try {
                InfluxDBEventReporter eventReporter = ((InfluxDBEventReporter.BuilderImpl)((InfluxDBEventReporter.BuilderImpl)InfluxDBEventReporter.Factory.forContext((MetricContext)RootMetricContext.get()).withConnectionType(connectionType)).withConnection(url, username, password, eventsDatabase)).build();
                this.codahaleScheduledReporters.add((com.codahale.metrics.ScheduledReporter)this.codahaleReportersCloser.register((Closeable)eventReporter));
            }
            catch (IOException e) {
                reporterExceptionList.add(new MetricReporterException("Failed to create InfluxDB event reporter.", (Throwable)e, ReporterType.EVENT, ReporterSinkType.INFLUXDB));
            }
        }
        if (!reporterExceptionList.isEmpty()) {
            throw new MultiReporterException("Failed to create one or more InfluxDB reporters", (List)reporterExceptionList);
        }
    }

    private void buildCustomMetricReporters(Properties properties, List<MetricReporterException> reporterExceptions) {
        String reporterClasses = properties.getProperty("metrics.reporting.custom.builders");
        if (Strings.isNullOrEmpty((String)reporterClasses)) {
            return;
        }
        for (String reporterClass : Splitter.on((String)",").split((CharSequence)reporterClasses)) {
            try {
                this.buildScheduledReporter(properties, reporterClass);
            }
            catch (MetricReporterException e) {
                reporterExceptions.add(e);
            }
        }
    }

    private void buildScheduledReporter(Properties properties, String reporterClass) throws MetricReporterException {
        block8: {
            try {
                Class<?> clazz = Class.forName(reporterClass);
                if (CustomCodahaleReporterFactory.class.isAssignableFrom(clazz)) {
                    CustomCodahaleReporterFactory customCodahaleReporterFactory = (CustomCodahaleReporterFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    com.codahale.metrics.ScheduledReporter scheduledReporter = customCodahaleReporterFactory.newScheduledReporter((MetricRegistry)RootMetricContext.get(), properties);
                    if (scheduledReporter == null) {
                        LOGGER.warn("Factory {} returns a null scheduledReporter", (Object)clazz.getSimpleName());
                        return;
                    }
                    this.codahaleReportersCloser.register((Closeable)scheduledReporter);
                    LOGGER.info("Will start reporting metrics using " + reporterClass);
                    this.codahaleScheduledReporters.add(scheduledReporter);
                    break block8;
                }
                if (CustomReporterFactory.class.isAssignableFrom(clazz)) {
                    CustomReporterFactory customReporterFactory = (CustomReporterFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    customReporterFactory.newScheduledReporter(properties);
                    LOGGER.info("Will start reporting metrics using " + reporterClass);
                    break block8;
                }
                throw new MetricReporterException("Class " + reporterClass + " specified by key " + "metrics.reporting.custom.builders" + " must implement: " + CustomCodahaleReporterFactory.class + " or " + CustomReporterFactory.class, ReporterType.CUSTOM, ReporterSinkType.CUSTOM);
            }
            catch (ClassNotFoundException exception) {
                throw new MetricReporterException(String.format("Failed to create metric reporter: requested CustomReporterFactory %s not found.", reporterClass), (Throwable)exception, ReporterType.CUSTOM, ReporterSinkType.CUSTOM);
            }
            catch (NoSuchMethodException exception) {
                throw new MetricReporterException(String.format("Failed to create metric reporter: requested CustomReporterFactory %s does not have parameterless constructor.", reporterClass), (Throwable)exception, ReporterType.CUSTOM, ReporterSinkType.CUSTOM);
            }
            catch (MetricReporterException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new MetricReporterException("Could not create metric reporter from builder " + reporterClass + ".", (Throwable)exception, ReporterType.CUSTOM, ReporterSinkType.CUSTOM);
            }
        }
    }

    public static GobblinMetricsRegistry getGOBBLIN_METRICS_REGISTRY() {
        return GOBBLIN_METRICS_REGISTRY;
    }

    public static enum MetricType {
        COUNTER,
        METER,
        GAUGE;

    }
}

