/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.iceberg;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.iceberg.Utils.IcebergUtils;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metadata.DataFile;
import org.apache.gobblin.metadata.DataMetrics;
import org.apache.gobblin.metadata.DataOrigin;
import org.apache.gobblin.metadata.DatasetIdentifier;
import org.apache.gobblin.metadata.GobblinMetadataChangeEvent;
import org.apache.gobblin.metadata.IntegerBytesPair;
import org.apache.gobblin.metadata.IntegerLongPair;
import org.apache.gobblin.metadata.OperationType;
import org.apache.gobblin.metadata.SchemaSource;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.util.ClustersNames;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GobblinMCEProducer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(GobblinMCEProducer.class);
    public static final String GMCE_PRODUCER_CLASS = "GobblinMCEProducer.class.name";
    public static final String GMCE_CLUSTER_NAME = "GobblinMCE.cluster.name";
    public static final String OLD_FILES_HIVE_REGISTRATION_KEY = "old.files.hive.registration.policy";
    private static final String HDFS_PLATFORM_URN = "urn:li:dataPlatform:hdfs";
    private static final String DATASET_ORIGIN_KEY = "dataset.origin";
    private static final String DEFAULT_DATASET_ORIGIN = "PROD";
    protected State state;
    protected MetricContext metricContext;

    public GobblinMCEProducer(State state) {
        this.state = state;
        this.metricContext = Instrumented.getMetricContext((State)state, this.getClass());
    }

    public void sendGMCE(Map<Path, Metrics> newFiles, List<String> oldFiles, List<String> oldFilePrefixes, Map<String, String> offsetRange, OperationType operationType, SchemaSource schemaSource) throws IOException {
        GobblinMetadataChangeEvent gmce = this.getGobblinMetadataChangeEvent(newFiles, oldFiles, oldFilePrefixes, offsetRange, operationType, schemaSource);
        this.underlyingSendGMCE(gmce);
    }

    public abstract void underlyingSendGMCE(GobblinMetadataChangeEvent var1);

    private void setBasicInformationForGMCE(GobblinMetadataChangeEvent.Builder gmceBuilder, Map<String, String> offsetRange, SchemaSource schemaSource) {
        String schemaString;
        String origin = this.state.getProp(DATASET_ORIGIN_KEY, DEFAULT_DATASET_ORIGIN);
        gmceBuilder.setDatasetIdentifier(DatasetIdentifier.newBuilder().setDataPlatformUrn(HDFS_PLATFORM_URN).setDataOrigin(DataOrigin.valueOf((String)origin)).setNativeName(this.state.getProp("data.publisher.dataset.dir")).build());
        gmceBuilder.setCluster(this.state.getProp(GMCE_CLUSTER_NAME, ClustersNames.getInstance().getClusterName()));
        gmceBuilder.setFlowId(this.state.getProp("job.id", new Configuration().get("azkaban.flow.flowid")));
        gmceBuilder.setRegistrationPolicy(this.state.getProp("hive.registration.policy"));
        gmceBuilder.setSchemaSource(schemaSource);
        gmceBuilder.setPartitionColumns((List)Lists.newArrayList((Object[])new String[]{this.state.getProp("hive.partition.name", "")}));
        if (offsetRange != null) {
            gmceBuilder.setTopicPartitionOffsetsRange(offsetRange);
        }
        if ((schemaString = this.state.getProp("writer.latest.schema")) != null) {
            gmceBuilder.setTableSchema(schemaString);
        }
        if (this.state.contains("avro.schema.with.iceberg.id")) {
            gmceBuilder.setAvroSchemaWithIcebergSchemaID(this.state.getProp("avro.schema.with.iceberg.id"));
        }
        if (this.state.contains(OLD_FILES_HIVE_REGISTRATION_KEY)) {
            gmceBuilder.setRegistrationPolicyForOldData(this.state.getProp(OLD_FILES_HIVE_REGISTRATION_KEY));
        } else {
            log.warn("properties {} does not set, if it's for rewrite/drop operation, there may be trouble to get partition value for old data", (Object)OLD_FILES_HIVE_REGISTRATION_KEY);
        }
        HashMap<String, String> regProperties = new HashMap<String, String>();
        if (this.state.contains("hive.database.name")) {
            regProperties.put("hive.database.name", this.state.getProp("hive.database.name"));
        }
        if (this.state.contains("additional.hive.database.names")) {
            regProperties.put("additional.hive.database.names", this.state.getProp("additional.hive.database.names"));
        }
        if (this.state.contains("additional.hive.table.names")) {
            regProperties.put("additional.hive.table.names", this.state.getProp("additional.hive.table.names"));
        }
        if (this.state.contains("hiveRegister.schema.source.dbName")) {
            regProperties.put("hiveRegister.schema.source.dbName", this.state.getProp("hiveRegister.schema.source.dbName"));
        }
        if (!regProperties.isEmpty()) {
            gmceBuilder.setRegistrationProperties(regProperties);
        }
    }

    public GobblinMetadataChangeEvent getGobblinMetadataChangeEvent(Map<Path, Metrics> newFiles, List<String> oldFiles, List<String> oldFilePrefixes, Map<String, String> offsetRange, OperationType operationType, SchemaSource schemaSource) {
        if (!this.verifyInput(newFiles, oldFiles, oldFilePrefixes, operationType)) {
            return null;
        }
        GobblinMetadataChangeEvent.Builder gmceBuilder = GobblinMetadataChangeEvent.newBuilder();
        this.setBasicInformationForGMCE(gmceBuilder, offsetRange, schemaSource);
        if (newFiles != null && !newFiles.isEmpty()) {
            gmceBuilder.setNewFiles(this.toGobblinDataFileList(newFiles));
        }
        if (oldFiles != null && !oldFiles.isEmpty()) {
            gmceBuilder.setOldFiles(oldFiles);
        }
        if (oldFilePrefixes != null && !oldFilePrefixes.isEmpty()) {
            gmceBuilder.setOldFilePrefixes(oldFilePrefixes);
        }
        gmceBuilder.setOperationType(operationType);
        return gmceBuilder.build();
    }

    private boolean verifyInput(Map<Path, Metrics> newFiles, List<String> oldFiles, List<String> oldFilePrefixes, OperationType operationType) {
        switch (operationType) {
            case rewrite_files: {
                if (newFiles != null && (oldFiles != null && !oldFiles.isEmpty() || oldFilePrefixes != null && !oldFilePrefixes.isEmpty()) && !newFiles.isEmpty()) break;
                log.error("Rewrite files operation must contain newFiles to be added and oldFiles to be deleted");
                return false;
            }
            case add_files: {
                if (newFiles != null && !newFiles.isEmpty()) break;
                log.error("Add files operation must contain newFiles to be added");
                return false;
            }
            case drop_files: {
                if (oldFiles != null && !oldFiles.isEmpty() || oldFilePrefixes != null && !oldFilePrefixes.isEmpty()) break;
                log.error("Drop files operation must contain old files to be deleted");
                return false;
            }
            case change_property: {
                if (oldFiles != null) {
                    log.warn("{} old files detected while no file alteration is performed", (Object)oldFiles.size());
                }
                log.info("Setting GMCE while no file changes need to be performed.");
                break;
            }
            default: {
                log.error("Unsupported operation type {}", (Object)operationType);
                return false;
            }
        }
        return true;
    }

    private List<DataFile> toGobblinDataFileList(Map<Path, Metrics> files) {
        return Lists.newArrayList((Iterable)Iterables.transform(files.entrySet(), file -> {
            DataFile.Builder builder = this.createBuilderWithFilePath((Path)file.getKey());
            this.addMetricsToFileBuilder(builder, (Metrics)file.getValue());
            return builder.build();
        }));
    }

    private DataFile.Builder createBuilderWithFilePath(Path filePath) {
        return DataFile.newBuilder().setFilePath(filePath.toString()).setFileFormat(IcebergUtils.getIcebergFormat(this.state).toString());
    }

    private void addMetricsToFileBuilder(DataFile.Builder builder, Metrics metrics) {
        if (metrics == null || metrics.recordCount() == null) {
            builder.setFileMetrics(DataMetrics.newBuilder().setRecordCount(0L).build());
            return;
        }
        builder.setFileMetrics(DataMetrics.newBuilder().setRecordCount(metrics.recordCount().longValue()).setColumnSizes(this.getIntegerLongPairsFromMap(metrics.columnSizes())).setValueCounts(this.getIntegerLongPairsFromMap(metrics.valueCounts())).setNullValueCounts(this.getIntegerLongPairsFromMap(metrics.nullValueCounts())).setLowerBounds(this.getIntegerBytesPairsFromMap(metrics.lowerBounds())).setUpperBounds(this.getIntegerBytesPairsFromMap(metrics.upperBounds())).build());
    }

    private List<IntegerLongPair> getIntegerLongPairsFromMap(Map<Integer, Long> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        Set<Map.Entry<Integer, Long>> entries = map.entrySet();
        Iterable pairs = Iterables.transform(entries, entry -> new IntegerLongPair((Integer)entry.getKey(), (Long)entry.getValue()));
        return Lists.newArrayList((Iterable)pairs);
    }

    private List<IntegerBytesPair> getIntegerBytesPairsFromMap(Map<Integer, ByteBuffer> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        Set<Map.Entry<Integer, ByteBuffer>> entries = map.entrySet();
        Iterable pairs = Iterables.transform(entries, entry -> new IntegerBytesPair((Integer)entry.getKey(), (ByteBuffer)entry.getValue()));
        return Lists.newArrayList((Iterable)pairs);
    }

    public static GobblinMCEProducer getGobblinMCEProducer(State state) {
        return (GobblinMCEProducer)GobblinConstructorUtils.invokeConstructor(GobblinMCEProducer.class, (String)state.getProp(GMCE_PRODUCER_CLASS), (Object[])new Object[]{state});
    }

    @Override
    public void close() throws IOException {
        this.metricContext.close();
    }

    public void setState(State state) {
        this.state = state;
    }
}

