/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.writer;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.gobblin.elasticsearch.typemapping.JsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.TypeMapper;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterConfigurationKeys;
import org.apache.gobblin.elasticsearch.writer.FutureCallbackHolder;
import org.apache.gobblin.elasticsearch.writer.MalformedDocPolicy;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.WriteCallback;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticsearchWriterBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchWriterBase.class);
    protected final String indexName;
    protected final String indexType;
    protected final TypeMapper typeMapper;
    protected final JsonSerializer serializer;
    protected final boolean idMappingEnabled;
    protected final String idFieldName;
    List<InetSocketTransportAddress> hostAddresses;
    protected final MalformedDocPolicy malformedDocPolicy;

    ElasticsearchWriterBase(Config config) throws UnknownHostException {
        this.indexName = config.getString(ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_INDEX_NAME);
        Preconditions.checkNotNull((Object)this.indexName, (Object)("Index Name not provided. Please set " + ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_INDEX_NAME));
        Preconditions.checkArgument((boolean)this.indexName.equals(this.indexName.toLowerCase()), (Object)("Index name must be lowercase, you provided " + this.indexName));
        this.indexType = config.getString(ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_INDEX_TYPE);
        Preconditions.checkNotNull((Object)this.indexName, (Object)("Index Type not provided. Please set " + ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_INDEX_TYPE));
        this.idMappingEnabled = ConfigUtils.getBoolean((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_ID_MAPPING_ENABLED, (boolean)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_ID_MAPPING_DEFAULT);
        this.idFieldName = ConfigUtils.getString((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_ID_FIELD, (String)"id");
        String typeMapperClassName = ConfigUtils.getString((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_TYPEMAPPER_CLASS, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_TYPEMAPPER_CLASS_DEFAULT);
        if (typeMapperClassName.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getCanonicalName() + " needs to be configured with " + ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_TYPEMAPPER_CLASS + " to enable type mapping");
        }
        try {
            Class<?> typeMapperClass = Class.forName(typeMapperClassName);
            this.typeMapper = (TypeMapper)ConstructorUtils.invokeConstructor(typeMapperClass, (Object[])new Object[0]);
            this.typeMapper.configure(config);
            this.serializer = this.typeMapper.getSerializer();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to instantiate type-mapper from class " + typeMapperClassName, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        this.malformedDocPolicy = MalformedDocPolicy.valueOf(ConfigUtils.getString((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_MALFORMED_DOC_POLICY, (String)"FAIL"));
        if (!config.hasPath(ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_HOSTS)) {
            InetSocketTransportAddress hostAddress = new InetSocketTransportAddress(InetAddress.getByName("localhost"), this.getDefaultPort());
            this.hostAddresses = new ArrayList<InetSocketTransportAddress>(1);
            this.hostAddresses.add(hostAddress);
            log.info("Adding host {} to Elasticsearch writer", (Object)hostAddress);
        } else {
            List hosts = ConfigUtils.getStringList((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_HOSTS);
            Splitter hostSplitter = Splitter.on((String)":").trimResults();
            this.hostAddresses = new ArrayList<InetSocketTransportAddress>(hosts.size());
            for (String host : hosts) {
                List hostSplit = hostSplitter.splitToList((CharSequence)host);
                Preconditions.checkArgument((hostSplit.size() == 1 || hostSplit.size() == 2 ? 1 : 0) != 0, (Object)("Malformed host name for Elasticsearch writer: " + host + " host names must be of form [host] or [host]:[port]"));
                InetAddress hostInetAddress = InetAddress.getByName((String)hostSplit.get(0));
                InetSocketTransportAddress hostAddress = null;
                if (hostSplit.size() == 1) {
                    hostAddress = new InetSocketTransportAddress(hostInetAddress, this.getDefaultPort());
                } else if (hostSplit.size() == 2) {
                    hostAddress = new InetSocketTransportAddress(hostInetAddress, Integer.parseInt((String)hostSplit.get(1)));
                }
                this.hostAddresses.add(hostAddress);
                log.info("Adding host {} to Elasticsearch writer", (Object)hostAddress);
            }
        }
    }

    abstract int getDefaultPort();

    protected Pair<BulkRequest, FutureCallbackHolder> prepareBatch(Batch<Object> batch, WriteCallback callback) {
        BulkRequest bulkRequest = new BulkRequest();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object record : batch.getRecords()) {
            try {
                byte[] serializedBytes = this.serializer.serializeToJson(record);
                log.debug("serialized record: {}", (Object)serializedBytes);
                IndexRequest indexRequest = new IndexRequest(this.indexName, this.indexType).source(serializedBytes, 0, serializedBytes.length, XContentType.JSON);
                if (this.idMappingEnabled) {
                    String id = this.typeMapper.getValue(this.idFieldName, record);
                    indexRequest.id(id);
                    stringBuilder.append(";").append(id);
                }
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                log.error("Encountered exception {}", (Throwable)e);
            }
        }
        FutureCallbackHolder futureCallbackHolder = new FutureCallbackHolder(callback, exception -> log.error("Batch: {} failed on ids; {} with exception {}", new Object[]{batch.getId(), stringBuilder.toString(), exception}), this.malformedDocPolicy);
        return new Pair((Object)bulkRequest, (Object)futureCallbackHolder);
    }

    @Override
    public void close() throws IOException {
        this.serializer.close();
    }
}

