/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.writer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.Pair;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterBase;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterConfigurationKeys;
import org.apache.gobblin.elasticsearch.writer.FutureCallbackHolder;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.BatchAsyncDataWriter;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticsearchTransportClientWriter
extends ElasticsearchWriterBase
implements BatchAsyncDataWriter<Object> {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchTransportClientWriter.class);
    private final TransportClient client;

    ElasticsearchTransportClientWriter(Config config) throws UnknownHostException {
        super(config);
        Preconditions.checkArgument((!ConfigUtils.getBoolean((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_SSL_ENABLED, (boolean)false) ? 1 : 0) != 0, (Object)"Transport client does not support ssl, try the Rest client instead");
        this.client = this.createTransportClient(config);
        log.info("ElasticsearchWriter configured successfully with: indexName={}, indexType={}, idMappingEnabled={}, typeMapperClassName={}", new Object[]{this.indexName, this.indexType, this.idMappingEnabled, this.typeMapper});
    }

    @Override
    int getDefaultPort() {
        return 9300;
    }

    public Future<WriteResponse> write(Batch<Object> batch, @Nullable WriteCallback callback) {
        Pair<BulkRequest, FutureCallbackHolder> preparedBatch = this.prepareBatch(batch, callback);
        this.client.bulk((BulkRequest)preparedBatch.getFirst(), ((FutureCallbackHolder)preparedBatch.getSecond()).getActionListener());
        return ((FutureCallbackHolder)preparedBatch.getSecond()).getFuture();
    }

    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        log.info("Got a close call in ElasticSearchTransportWriter");
        super.close();
        this.client.close();
    }

    @VisibleForTesting
    TransportClient getTransportClient() {
        return this.client;
    }

    private TransportClient createTransportClient(Config config) throws UnknownHostException {
        Settings.Builder settingsBuilder = Settings.builder();
        if (config.hasPath(ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_SETTINGS)) {
            settingsBuilder.put((Dictionary)ConfigUtils.configToProperties((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_SETTINGS));
        }
        settingsBuilder.put("client.transport.ignore_cluster_name", true);
        settingsBuilder.put("client.transport.sniff", true);
        PreBuiltTransportClient transportClient = new PreBuiltTransportClient(settingsBuilder.build(), new Class[0]);
        this.hostAddresses.forEach(arg_0 -> ((TransportClient)transportClient).addTransportAddress(arg_0));
        return transportClient;
    }
}

