/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.typemapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.gobblin.elasticsearch.typemapping.FieldMappingException;
import org.apache.gobblin.elasticsearch.typemapping.GsonJsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.JsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.TypeMapper;

public class JsonTypeMapper
implements TypeMapper<JsonElement> {
    private final JsonSerializer serializer = new GsonJsonSerializer();

    @Override
    public void configure(Config config) {
    }

    @Override
    public JsonSerializer<JsonElement> getSerializer() {
        return this.serializer;
    }

    @Override
    public String getValue(String fieldName, JsonElement record) throws FieldMappingException {
        assert (record.isJsonObject());
        JsonObject jsonObject = record.getAsJsonObject();
        if (jsonObject.has(fieldName)) {
            return jsonObject.get(fieldName).getAsString();
        }
        throw new FieldMappingException("Could not find field :" + fieldName);
    }

    @Override
    public void close() throws IOException {
    }
}

