/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.typemapping;

import com.google.gson.Gson;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.gobblin.elasticsearch.typemapping.JsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.SerializationException;

public class GsonJsonSerializer
implements JsonSerializer<Object> {
    private final Gson _gson = new Gson();

    @Override
    public void configure(Config config) {
    }

    @Override
    public byte[] serializeToJson(Object serializable) throws SerializationException {
        String jsonString = this._gson.toJson(serializable);
        try {
            return jsonString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

