/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.copy.AllEqualComparator;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.IterableCopyableDataset;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.WhitelistBlacklist;
import org.apache.gobblin.data.management.copy.prioritization.FileSetComparator;
import org.apache.gobblin.data.management.partition.CopyableDatasetRequestor;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.gobblin.util.request_allocation.SimpleHierarchicalPrioritizer;

@Alias(value="HiveSimpleTiering")
public class SimpleHiveDatasetTieringPrioritizer
extends SimpleHierarchicalPrioritizer<FileSet<CopyEntity>>
implements FileSetComparator,
Serializable {
    public static final String CONFIGURATION_PREFIX = "gobblin.prioritizer.hiveDatasetTiering";
    public static final String TIER_KEY = "gobblin.prioritizer.hiveDatasetTiering.tier";
    private static final Pattern TIER_PATTERN = Pattern.compile("gobblin.prioritizer.hiveDatasetTiering.tier\\.([0-9]+)");

    public SimpleHiveDatasetTieringPrioritizer(Properties properties) throws IOException {
        super(SimpleHiveDatasetTieringPrioritizer.createRequestorComparator(properties), new AllEqualComparator());
    }

    private static Comparator<Requestor<FileSet<CopyEntity>>> createRequestorComparator(Properties props) throws IOException {
        TreeMap tiers = Maps.newTreeMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Matcher matcher;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(matcher = TIER_PATTERN.matcher((String)entry.getKey())).matches()) continue;
            int tier = Integer.parseInt(matcher.group(1));
            WhitelistBlacklist whitelistBlacklist = new WhitelistBlacklist((String)entry.getValue(), "");
            tiers.put(tier, whitelistBlacklist);
        }
        return new TierComparator(tiers);
    }

    private static class TierComparator
    implements Comparator<Requestor<FileSet<CopyEntity>>>,
    Serializable {
        private final TreeMap<Integer, WhitelistBlacklist> tiersMap;

        @Override
        public int compare(Requestor<FileSet<CopyEntity>> o1, Requestor<FileSet<CopyEntity>> o2) {
            return Integer.compare(this.findTier(o1), this.findTier(o2));
        }

        private int findTier(Requestor<FileSet<CopyEntity>> requestor) {
            if (!(requestor instanceof CopyableDatasetRequestor)) {
                throw new ClassCastException(String.format("%s can only be used for %s.", SimpleHiveDatasetTieringPrioritizer.class.getName(), CopyableDatasetRequestor.class.getName()));
            }
            IterableCopyableDataset dataset = ((CopyableDatasetRequestor)requestor).getDataset();
            if (!(dataset instanceof HiveDataset)) {
                throw new ClassCastException(String.format("%s can only be used for %s.", SimpleHiveDatasetTieringPrioritizer.class.getName(), HiveDataset.class.getName()));
            }
            HiveDataset hiveDataset = (HiveDataset)dataset;
            for (Map.Entry<Integer, WhitelistBlacklist> tier : this.tiersMap.entrySet()) {
                WhitelistBlacklist whitelistBlacklist = tier.getValue();
                if (!whitelistBlacklist.acceptTable(hiveDataset.getTable().getDbName(), hiveDataset.getTable().getTableName())) continue;
                return tier.getKey();
            }
            return Integer.MAX_VALUE;
        }

        public TierComparator(TreeMap<Integer, WhitelistBlacklist> tiersMap) {
            this.tiersMap = tiersMap;
        }
    }
}

