/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.DateTimeDatasetVersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class LookbackDateTimeDatasetVersionFinder
extends DateTimeDatasetVersionFinder {
    public static final String VERSION_PATH_PREFIX = "version.path.prefix";
    public static final String VERSION_LOOKBACK_PERIOD = "version.lookback.period";
    private final Duration stepDuration;
    private final Period lookbackPeriod;
    private final String pathPrefix;
    private final Instant endTime;

    public LookbackDateTimeDatasetVersionFinder(FileSystem fs, Config config) {
        this(fs, config, Instant.now());
    }

    @VisibleForTesting
    public LookbackDateTimeDatasetVersionFinder(FileSystem fs, Config config, Instant endTime) {
        super(fs, config);
        Preconditions.checkArgument((boolean)config.hasPath(VERSION_LOOKBACK_PERIOD), (Object)"Missing required property version.lookback.period");
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendYears().appendSuffix("y").appendMonths().appendSuffix("M").appendDays().appendSuffix("d").appendHours().appendSuffix("h").toFormatter();
        this.stepDuration = Duration.standardHours((long)1L);
        this.pathPrefix = ConfigUtils.getString((Config)config, (String)VERSION_PATH_PREFIX, (String)"");
        this.lookbackPeriod = periodFormatter.parsePeriod(config.getString(VERSION_LOOKBACK_PERIOD));
        this.endTime = endTime;
    }

    @Override
    public Collection<TimestampedDatasetVersion> findDatasetVersions(Dataset dataset) throws IOException {
        Instant startTime;
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        HashSet<TimestampedDatasetVersion> versions = new HashSet<TimestampedDatasetVersion>();
        Instant time = startTime = this.endTime.minus((ReadableDuration)this.lookbackPeriod.toStandardDuration());
        while (!time.isAfter((ReadableInstant)this.endTime)) {
            String truncatedTime = this.formatter.print((ReadableInstant)time);
            DateTime versionTime = this.formatter.parseDateTime(truncatedTime);
            Path versionPath = new Path(fsDataset.datasetRoot(), new Path(this.pathPrefix, truncatedTime));
            versions.add(new TimestampedDatasetVersion(versionTime, versionPath));
            time = time.plus((ReadableDuration)this.stepDuration);
        }
        return versions;
    }
}

