/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.gobblin.data.management.version.TimestampedHiveDatasetVersion;
import org.apache.gobblin.data.management.version.finder.AbstractHiveDatasetVersionFinder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.joda.time.DateTime;

public class HdfsModifiedTimeHiveVersionFinder
extends AbstractHiveDatasetVersionFinder {
    private final FileSystem fs;

    public HdfsModifiedTimeHiveVersionFinder(FileSystem fs, Config config) {
        this.fs = fs;
    }

    @Override
    protected TimestampedHiveDatasetVersion getDatasetVersion(Partition partition) {
        try {
            Preconditions.checkArgument((partition != null ? 1 : 0) != 0, (Object)"Argument to method ");
            Path dataLocation = partition.getDataLocation();
            Preconditions.checkArgument((dataLocation != null ? 1 : 0) != 0, (Object)("Data location is null for partition " + partition.getCompleteName()));
            boolean exists = this.fs.exists(dataLocation);
            Preconditions.checkArgument((boolean)exists, (Object)("Data location doesn't exist for partition " + partition.getCompleteName()));
            long modificationTS = this.fs.getFileStatus(dataLocation).getModificationTime();
            return new TimestampedHiveDatasetVersion(new DateTime(modificationTS), partition);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

