/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version;

import org.apache.gobblin.data.management.version.DatasetStateStoreVersion;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TimestampedDatasetStateStoreVersion
extends TimestampedDatasetVersion
implements DatasetStateStoreVersion {
    private final DatasetStateStoreEntryManager entry;

    public TimestampedDatasetStateStoreVersion(DatasetStateStoreEntryManager entry) {
        super(new DateTime(entry.getTimestamp()), null);
        this.entry = entry;
    }

    @Override
    public int compareTo(FileSystemDatasetVersion other) {
        TimestampedDatasetVersion otherAsDateTime = (TimestampedDatasetVersion)other;
        return this.version.equals((Object)otherAsDateTime.version) ? 0 : this.version.compareTo((ReadableInstant)otherAsDateTime.version);
    }

    @Override
    public boolean equals(Object obj) {
        TimestampedDatasetStateStoreVersion other;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof TimestampedDatasetStateStoreVersion && this.entry.equals((Object)(other = (TimestampedDatasetStateStoreVersion)obj).getEntry())) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.version.hashCode();
        result = 31 * result + (this.entry != null ? this.entry.hashCode() : 0);
        return result;
    }

    @Override
    public DatasetStateStoreEntryManager getEntry() {
        return this.entry;
    }
}

