/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.trash.ImmediateDeletionTrash;
import org.apache.gobblin.data.management.trash.MockTrash;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.trash.TestTrash;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TrashFactory.class);
    public static final String TRASH_TEST = "gobblin.trash.test";
    public static final String SIMULATE = "gobblin.trash.simulate";
    public static final String SKIP_TRASH = "gobblin.trash.skip.trash";

    public static Trash createTrash(FileSystem fs) throws IOException {
        return TrashFactory.createTrash(fs, new Properties());
    }

    public static Trash createTrash(FileSystem fs, Properties props) throws IOException {
        return TrashFactory.createTrash(fs, props, UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public static Trash createTrash(FileSystem fs, Properties props, String user) throws IOException {
        ProxiedTrash trash = TrashFactory.createTestMockOrImmediateDeletionTrash(fs, props, user);
        if (null != trash) {
            return trash;
        }
        return Trash.getTrash(fs, props, user);
    }

    public static ProxiedTrash createProxiedTrash(FileSystem fs) throws IOException {
        return TrashFactory.createProxiedTrash(fs, new Properties());
    }

    public static ProxiedTrash createProxiedTrash(FileSystem fs, Properties props) throws IOException {
        return TrashFactory.createProxiedTrash(fs, props, UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public static ProxiedTrash createProxiedTrash(FileSystem fs, Properties props, String user) throws IOException {
        ProxiedTrash trash = TrashFactory.createTestMockOrImmediateDeletionTrash(fs, props, user);
        if (null != trash) {
            return trash;
        }
        return ProxiedTrash.getProxiedTrash(fs, props, user);
    }

    private static ProxiedTrash createTestMockOrImmediateDeletionTrash(FileSystem fs, Properties props, String user) throws IOException {
        if (props.containsKey(TRASH_TEST) && Boolean.parseBoolean(props.getProperty(TRASH_TEST))) {
            LOG.info("Creating a test trash. Nothing will actually be deleted.");
            return new TestTrash(fs, props, user);
        }
        if (props.containsKey(SIMULATE) && Boolean.parseBoolean(props.getProperty(SIMULATE))) {
            LOG.info("Creating a simulate trash. Nothing will actually be deleted.");
            return new MockTrash(fs, props, user);
        }
        if (props.containsKey(SKIP_TRASH) && Boolean.parseBoolean(props.getProperty(SKIP_TRASH))) {
            LOG.info("Creating an immediate deletion trash. Files will be deleted immediately instead of moved to trash.");
            return new ImmediateDeletionTrash(fs, props, user);
        }
        return null;
    }
}

