/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.gobblin.data.management.trash.MockTrash;
import org.apache.gobblin.data.management.trash.NoopSnapshotCleanupPolicy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestTrash
extends MockTrash {
    private static final String DELAY_TICKS_KEY = "gobblin.trash.test.delays.ticks";
    private final List<DeleteOperation> deleteOperations;
    private final String user;
    private final long delay;
    private long clockState;
    private final Lock lock;
    private final Condition clockStateUpdated;
    private final Condition signalReceived;
    private final AtomicLong callsReceivedSignal;
    private final AtomicLong operationsWaiting;
    private final AtomicLong operationsReceived;
    private final boolean simulate;
    private final boolean skipTrash;

    public static Properties propertiesForTestTrash() {
        Properties properties = new Properties();
        properties.setProperty("gobblin.trash.test", Boolean.toString(true));
        return properties;
    }

    public static void simulateDelay(Properties properties, long delay) {
        properties.setProperty(DELAY_TICKS_KEY, Long.toString(delay));
    }

    public TestTrash(FileSystem fs, Properties props, String user) throws IOException {
        super(fs, TestTrash.propertiesForConstruction(props), user);
        this.user = user;
        this.deleteOperations = Lists.newArrayList();
        this.simulate = props.containsKey("gobblin.trash.simulate") && Boolean.parseBoolean(props.getProperty("gobblin.trash.simulate"));
        this.skipTrash = props.containsKey("gobblin.trash.skip.trash") && Boolean.parseBoolean(props.getProperty("gobblin.trash.skip.trash"));
        this.operationsReceived = new AtomicLong();
        this.lock = new ReentrantLock();
        this.clockStateUpdated = this.lock.newCondition();
        this.signalReceived = this.lock.newCondition();
        this.clockState = 0L;
        this.operationsWaiting = new AtomicLong();
        this.callsReceivedSignal = new AtomicLong();
        this.delay = props.containsKey(DELAY_TICKS_KEY) ? Long.parseLong(props.getProperty(DELAY_TICKS_KEY)) : 0L;
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        this.operationsReceived.incrementAndGet();
        this.addDeleteOperation(new DeleteOperation(path, null));
        return true;
    }

    @Override
    public boolean moveToTrashAsUser(Path path, String user) throws IOException {
        this.operationsReceived.incrementAndGet();
        this.addDeleteOperation(new DeleteOperation(path, user));
        return true;
    }

    @Override
    public boolean moveToTrashAsOwner(Path path) throws IOException {
        return this.moveToTrashAsUser(path, this.user);
    }

    public long getOperationsReceived() {
        return this.operationsReceived.get();
    }

    public long getOperationsWaiting() {
        return this.operationsWaiting.get();
    }

    public void tick() {
        this.lock.lock();
        try {
            ++this.clockState;
            long callsAwaitingSignalOld = this.operationsWaiting.get();
            this.callsReceivedSignal.set(0L);
            this.operationsWaiting.set(0L);
            this.clockStateUpdated.signalAll();
            while (this.callsReceivedSignal.get() < callsAwaitingSignalOld) {
                this.signalReceived.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeleteOperation(DeleteOperation dop) {
        this.lock.lock();
        long executeAt = this.clockState + this.delay;
        boolean firstLoop = true;
        try {
            while (this.clockState < executeAt) {
                if (!firstLoop) {
                    this.callsReceivedSignal.incrementAndGet();
                    this.signalReceived.signalAll();
                }
                firstLoop = false;
                this.operationsWaiting.incrementAndGet();
                this.clockStateUpdated.await();
            }
            this.deleteOperations.add(dop);
            this.callsReceivedSignal.incrementAndGet();
            this.signalReceived.signal();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Properties propertiesForConstruction(Properties properties) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)properties);
        newProperties.setProperty("gobblin.trash.snapshot.cleanup.policy.class", NoopSnapshotCleanupPolicy.class.getCanonicalName());
        newProperties.setProperty("gobblin.trash.location", "/test/path");
        return newProperties;
    }

    public List<DeleteOperation> getDeleteOperations() {
        return this.deleteOperations;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public boolean isSkipTrash() {
        return this.skipTrash;
    }

    public static class DeleteOperation {
        private final Path path;
        private final String user;

        public DeleteOperation(Path path, String user) {
            this.path = path;
            this.user = user;
        }

        public Path getPath() {
            return this.path;
        }

        public String getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteOperation)) {
                return false;
            }
            DeleteOperation other = (DeleteOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            return !(this$user == null ? other$user != null : !this$user.equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeleteOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            return result;
        }

        public String toString() {
            return "TestTrash.DeleteOperation(path=" + this.getPath() + ", user=" + this.getUser() + ")";
        }
    }
}

