/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.ConfigClientCache;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiDatasetFinder
implements DatasetsFinder<Dataset> {
    private static final Logger log = LoggerFactory.getLogger(MultiDatasetFinder.class);
    private static final Splitter TAGS_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    List<DatasetsFinder<Dataset>> datasetFinders;
    protected final Properties jobProps;

    protected abstract String datasetFinderClassKey();

    protected abstract String datasetFinderImportedByKey();

    public MultiDatasetFinder(FileSystem fs, Properties jobProps) {
        this(fs, jobProps, new EventSubmitter.Builder(Optional.absent(), "noMessage").build());
    }

    public MultiDatasetFinder(FileSystem fs, Properties jobProps, EventSubmitter eventSubmitter) {
        this.jobProps = jobProps;
        try {
            this.datasetFinders = Lists.newArrayList();
            if (jobProps.containsKey(this.datasetFinderClassKey())) {
                try {
                    log.info(String.format("Instantiating datasetfinder %s ", jobProps.getProperty(this.datasetFinderClassKey())));
                    this.datasetFinders.add((DatasetsFinder<Dataset>)((DatasetsFinder)GobblinConstructorUtils.invokeLongestConstructor(Class.forName(jobProps.getProperty(this.datasetFinderClassKey())), (Object[])new Object[]{fs, jobProps, eventSubmitter})));
                }
                catch (ReflectiveOperationException e) {
                    log.error(String.format("Retention ignored could not instantiate datasetfinder %s.", jobProps.getProperty(this.datasetFinderClassKey())), (Throwable)e);
                    Throwables.propagate((Throwable)e);
                }
            } else if (jobProps.containsKey(this.datasetFinderImportedByKey())) {
                log.info("Instantiating dataset finders using tag " + jobProps.getProperty(this.datasetFinderImportedByKey()));
                ConfigClient client = ConfigClientCache.getClient((VersionStabilityPolicy)VersionStabilityPolicy.STRONG_LOCAL_STABILITY);
                ArrayList importedBys = Lists.newArrayList();
                for (String tag : TAGS_SPLITTER.split((CharSequence)jobProps.getProperty(this.datasetFinderImportedByKey()))) {
                    log.info("Looking for datasets that import tag " + tag);
                    importedBys.addAll(client.getImportedBy(new URI(tag), false));
                }
                for (URI importedBy : importedBys) {
                    Config datasetClassConfig = client.getConfig(importedBy);
                    try {
                        this.datasetFinders.add((DatasetsFinder<Dataset>)((DatasetsFinder)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(datasetClassConfig.getString(this.datasetFinderClassKey())), (List[])new List[]{ImmutableList.of((Object)fs, (Object)jobProps, (Object)datasetClassConfig), ImmutableList.of((Object)fs, (Object)jobProps, (Object)eventSubmitter), ImmutableList.of((Object)fs, (Object)jobProps)})));
                        log.info(String.format("Instantiated datasetfinder %s for %s.", datasetClassConfig.getString(this.datasetFinderClassKey()), importedBy));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        log.error(String.format("Retention ignored for %s. Could not instantiate datasetfinder %s.", importedBy, datasetClassConfig.getString(this.datasetFinderClassKey())), (Throwable)e);
                        Throwables.propagate((Throwable)e);
                    }
                }
            } else {
                log.warn(String.format("NO DATASET_FINDERS FOUND. Either specify dataset finder class at %s or specify the imported tags at %s", this.datasetFinderClassKey(), this.datasetFinderImportedByKey()));
            }
        }
        catch (IllegalArgumentException | URISyntaxException | ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException | VersionDoesNotExistException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public List<Dataset> findDatasets() throws IOException {
        ArrayList datasets = Lists.newArrayList();
        for (DatasetsFinder<Dataset> df : this.datasetFinders) {
            datasets.addAll(df.findDatasets());
        }
        return datasets;
    }

    public Path commonDatasetRoot() {
        throw new UnsupportedOperationException("There is no common dataset root for MultiDatasetFinder");
    }
}

