/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.retention.version.DatasetVersion;

@Alias(value="PredicateRetention")
public class PredicateRetentionPolicy
implements RetentionPolicy<DatasetVersion> {
    private final Predicate<DatasetVersion> predicate;
    private static final String RETENTION_POLICY_PREDICATE_CLASS = "org.apache.gobblin.retention.retention.policy.predicate.class";

    public PredicateRetentionPolicy(Properties props) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        this.predicate = (Predicate)Class.forName(props.getProperty(RETENTION_POLICY_PREDICATE_CLASS)).getConstructor(Properties.class).newInstance(props);
    }

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        return DatasetVersion.class;
    }

    @Override
    public Collection<DatasetVersion> listDeletableVersions(List<DatasetVersion> allVersions) {
        return Lists.newArrayList((Iterable)Iterables.filter(allVersions, (Predicate)Predicates.not(this.predicate)));
    }
}

