/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.dataset;

import com.typesafe.config.Config;
import org.apache.gobblin.data.management.dataset.SimpleDatasetRequestor;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.gobblin.util.request_allocation.ResourceEstimator;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;

public class SimpleDatasetRequest
implements Request<SimpleDatasetRequest> {
    public static final String SIMPLE_DATASET_COUNT_DIMENSION = "count";
    Dataset dataset;
    SimpleDatasetRequestor requestor;

    public Requestor<SimpleDatasetRequest> getRequestor() {
        return this.requestor;
    }

    public String toString() {
        return this.dataset.toString();
    }

    public SimpleDatasetRequest(Dataset dataset, SimpleDatasetRequestor requestor) {
        this.dataset = dataset;
        this.requestor = requestor;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public static class SimpleDatasetCountEstimator
    implements ResourceEstimator<SimpleDatasetRequest> {
        public ResourceRequirement estimateRequirement(SimpleDatasetRequest request, ResourcePool pool) {
            return new ResourceRequirement.Builder(pool).setRequirement(SimpleDatasetRequest.SIMPLE_DATASET_COUNT_DIMENSION, 1.0).build();
        }

        static class Factory
        implements ResourceEstimator.Factory<SimpleDatasetRequest> {
            Factory() {
            }

            public ResourceEstimator<SimpleDatasetRequest> create(Config config) {
                return new SimpleDatasetCountEstimator();
            }
        }
    }
}

