/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.gobblin.data.management.copy.replication.ConfigBasedDataset;
import org.apache.gobblin.data.management.copy.replication.CopyRoute;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGenerator;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.ReplicationConfiguration;
import org.apache.gobblin.data.management.copy.replication.ReplicationCopyMode;
import org.apache.gobblin.dataset.Dataset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedMultiDatasets {
    private static final Logger log = LoggerFactory.getLogger(ConfigBasedMultiDatasets.class);
    private final Properties props;
    private final List<Dataset> datasets = new ArrayList<Dataset>();
    private Optional<List<Pattern>> blacklist = Optional.of(new ArrayList());
    public static final String REPLICATION_PUSH_MODE = "gobblin.copy.replicationPushMode";

    public ConfigBasedMultiDatasets() {
        this.props = new Properties();
    }

    public ConfigBasedMultiDatasets(Config c, Properties props, Optional<List<String>> blacklistPatterns) {
        this.props = props;
        this.blacklist = this.patternListInitHelper(blacklistPatterns);
        try {
            FileSystem executionCluster = FileSystem.get((Configuration)new Configuration());
            URI executionClusterURI = executionCluster.getUri();
            ReplicationConfiguration rc = ReplicationConfiguration.buildFromConfig(c);
            if (this.props.containsKey(REPLICATION_PUSH_MODE) && Boolean.parseBoolean(this.props.getProperty(REPLICATION_PUSH_MODE))) {
                this.generateDatasetInPushMode(rc, executionClusterURI);
            } else {
                this.generateDatasetInPullMode(rc, executionClusterURI);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Can not create Replication Configuration from raw config " + c.root().render(ConfigRenderOptions.defaults().setComments(false).setOriginComments(false)), (Throwable)e);
        }
        catch (IOException ioe) {
            log.error("Can not decide current execution cluster ", (Throwable)ioe);
        }
    }

    private Optional<List<Pattern>> patternListInitHelper(Optional<List<String>> patterns) {
        if (patterns.isPresent() && ((List)patterns.get()).size() >= 1) {
            ArrayList<Pattern> tmpPatterns = new ArrayList<Pattern>();
            for (String pattern : (List)patterns.get()) {
                tmpPatterns.add(Pattern.compile(pattern));
            }
            return Optional.of(tmpPatterns);
        }
        return Optional.absent();
    }

    private void generateDatasetInPushMode(ReplicationConfiguration rc, URI executionClusterURI) {
        if (rc.getCopyMode() == ReplicationCopyMode.PULL) {
            log.info("Skip process pull mode dataset with meta data{} as job level property specify push mode ", (Object)rc.getMetaData());
            return;
        }
        if (!this.props.containsKey("writer.fs.uri")) {
            return;
        }
        String pushModeTargetCluster = this.props.getProperty("writer.fs.uri");
        CopyRouteGenerator cpGen = rc.getCopyRouteGenerator();
        List<EndPoint> replicas = rc.getReplicas();
        ArrayList<EndPoint> pushCandidates = new ArrayList<EndPoint>(replicas);
        pushCandidates.add(rc.getSource());
        for (EndPoint pushFrom : pushCandidates) {
            if (!this.needGenerateCopyEntity(pushFrom, executionClusterURI)) continue;
            Optional<List<CopyRoute>> copyRoutes = cpGen.getPushRoutes(rc, pushFrom);
            if (!copyRoutes.isPresent()) {
                log.warn("In Push mode, did not found any copyRoute for dataset with meta data {}", (Object)rc.getMetaData());
                continue;
            }
            for (CopyRoute cr : (List)copyRoutes.get()) {
                HadoopFsEndPoint ep;
                if (!(cr.getCopyTo() instanceof HadoopFsEndPoint) || !(ep = (HadoopFsEndPoint)cr.getCopyTo()).getFsURI().toString().equals(pushModeTargetCluster)) continue;
                ConfigBasedDataset configBasedDataset = new ConfigBasedDataset(rc, this.props, cr);
                if (this.blacklistFilteringHelper(configBasedDataset, this.blacklist)) {
                    this.datasets.add(configBasedDataset);
                    continue;
                }
                log.info("Dataset" + configBasedDataset.datasetURN() + " has been filtered out because of blacklist pattern:" + ((List)this.blacklist.get()).toString());
            }
        }
    }

    private void generateDatasetInPullMode(ReplicationConfiguration rc, URI executionClusterURI) {
        if (rc.getCopyMode() == ReplicationCopyMode.PUSH) {
            log.info("Skip process push mode dataset with meta data{} as job level property specify pull mode ", (Object)rc.getMetaData());
            return;
        }
        CopyRouteGenerator cpGen = rc.getCopyRouteGenerator();
        List<EndPoint> replicas = rc.getReplicas();
        for (EndPoint replica : replicas) {
            Optional<CopyRoute> copyRoute;
            if (!this.needGenerateCopyEntity(replica, executionClusterURI) || !(copyRoute = cpGen.getPullRoute(rc, replica)).isPresent()) continue;
            ConfigBasedDataset configBasedDataset = new ConfigBasedDataset(rc, this.props, (CopyRoute)copyRoute.get());
            if (this.blacklistFilteringHelper(configBasedDataset, this.blacklist)) {
                this.datasets.add(configBasedDataset);
                continue;
            }
            log.info("Dataset" + configBasedDataset.datasetURN() + " has been filtered out because of blacklist pattern:" + ((List)this.blacklist.get()).toString());
        }
    }

    @VisibleForTesting
    public boolean blacklistFilteringHelper(ConfigBasedDataset configBasedDataset, Optional<List<Pattern>> patternList) {
        String datasetURN = configBasedDataset.datasetURN();
        if (patternList.isPresent()) {
            for (Pattern pattern : (List)patternList.get()) {
                if (!pattern.matcher(datasetURN).find()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public List<Dataset> getConfigBasedDatasetList() {
        return this.datasets;
    }

    private boolean needGenerateCopyEntity(EndPoint e, URI executionClusterURI) {
        if (!(e instanceof HadoopFsEndPoint)) {
            return false;
        }
        HadoopFsEndPoint ep = (HadoopFsEndPoint)e;
        return ep.getFsURI().equals(executionClusterURI);
    }
}

