/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.publisher;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.metrics.event.sla.SlaEventSubmitter;

public class CopyEventSubmitterHelper {
    private static final String DATASET_PUBLISHED_EVENT_NAME = "DatasetPublished";
    private static final String DATASET_PUBLISHED_FAILED_EVENT_NAME = "DatasetPublishFailed";
    private static final String FILE_PUBLISHED_EVENT_NAME = "FilePublished";
    public static final String DATASET_ROOT_METADATA_NAME = "datasetUrn";
    public static final String DATASET_TARGET_ROOT_METADATA_NAME = "datasetTargetRoot";
    public static final String TARGET_PATH = "TargetPath";
    public static final String SOURCE_PATH = "SourcePath";
    public static final String SIZE_IN_BYTES = "SizeInBytes";

    static void submitSuccessfulDatasetPublish(EventSubmitter eventSubmitter, CopyEntity.DatasetAndPartition datasetAndPartition, String originTimestamp, String upstreamTimestamp, Map<String, String> additionalMetadata) {
        SlaEventSubmitter.builder().eventSubmitter(eventSubmitter).eventName(DATASET_PUBLISHED_EVENT_NAME).datasetUrn(datasetAndPartition.getDataset().getDatasetURN()).partition(datasetAndPartition.getPartition()).originTimestamp(originTimestamp).upstreamTimestamp(upstreamTimestamp).additionalMetadata(additionalMetadata).build().submit();
    }

    static void submitFailedDatasetPublish(EventSubmitter eventSubmitter, CopyEntity.DatasetAndPartition datasetAndPartition) {
        eventSubmitter.submit(DATASET_PUBLISHED_FAILED_EVENT_NAME, (Map)ImmutableMap.of((Object)DATASET_ROOT_METADATA_NAME, (Object)datasetAndPartition.getDataset().getDatasetURN()));
    }

    static void submitSuccessfulFilePublish(EventSubmitter eventSubmitter, CopyableFile cf, WorkUnitState workUnitState) {
        String datasetUrn = workUnitState.getProp("event.sla.datasetUrn");
        String partition = workUnitState.getProp("event.sla.partition");
        String completenessPercentage = workUnitState.getProp("event.sla.completenessPercentage");
        String recordCount = workUnitState.getProp("event.sla.recordCount");
        String previousPublishTimestamp = workUnitState.getProp("event.sla.previousPublishTs");
        String dedupeStatus = workUnitState.getProp("event.sla.dedupeStatus");
        SlaEventSubmitter.builder().eventSubmitter(eventSubmitter).eventName(FILE_PUBLISHED_EVENT_NAME).datasetUrn(datasetUrn).partition(partition).originTimestamp(Long.toString(cf.getOriginTimestamp())).upstreamTimestamp(Long.toString(cf.getUpstreamTimestamp())).completenessPercentage(completenessPercentage).recordCount(recordCount).previousPublishTimestamp(previousPublishTimestamp).dedupeStatus(dedupeStatus).additionalMetadata(TARGET_PATH, cf.getDestination().toString()).additionalMetadata(SOURCE_PATH, cf.getOrigin().getPath().toString()).additionalMetadata(SIZE_IN_BYTES, Long.toString(cf.getOrigin().getLen())).build().submit();
    }
}

