/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HivePartitionFileSet;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootDirectoryModtimeSkipPredicate
implements Predicate<HivePartitionFileSet> {
    private static final Logger log = LoggerFactory.getLogger(RootDirectoryModtimeSkipPredicate.class);
    private final HiveCopyEntityHelper helper;

    public boolean apply(@Nullable HivePartitionFileSet input) {
        if (input == null) {
            return true;
        }
        if (!input.getExistingTargetPartition().isPresent()) {
            return false;
        }
        try {
            if (PathUtils.isGlob((Path)input.getPartition().getDataLocation())) {
                log.error(String.format("%s cannot be applied to globbed location %s. Will not skip.", this.getClass().getSimpleName(), input.getPartition().getDataLocation()));
                return false;
            }
            Path targetPath = this.helper.getTargetFileSystem().makeQualified(this.helper.getTargetPathHelper().getTargetPath(input.getPartition().getDataLocation(), this.helper.getTargetFs(), (Optional<Partition>)Optional.of((Object)input.getPartition()), false));
            Optional<FileStatus> targetFileStatus = this.helper.getConfiguration().getCopyContext().getFileStatus(this.helper.getTargetFs(), targetPath);
            if (!targetFileStatus.isPresent()) {
                return false;
            }
            Optional<FileStatus> sourceFileStatus = this.helper.getConfiguration().getCopyContext().getFileStatus(this.helper.getDataset().getFs(), input.getPartition().getDataLocation());
            if (!sourceFileStatus.isPresent()) {
                throw new RuntimeException(String.format("Source path %s does not exist!", input.getPartition().getDataLocation()));
            }
            return ((FileStatus)targetFileStatus.get()).getModificationTime() > ((FileStatus)sourceFileStatus.get()).getModificationTime();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public RootDirectoryModtimeSkipPredicate(HiveCopyEntityHelper helper) {
        this.helper = helper;
    }
}

