/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.iceberg;

import java.util.Map;
import org.apache.gobblin.data.management.copy.iceberg.BaseIcebergCatalog;
import org.apache.gobblin.data.management.copy.iceberg.IcebergTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHiveCatalog
extends BaseIcebergCatalog {
    private static final Logger log = LoggerFactory.getLogger(IcebergHiveCatalog.class);
    public static final String HIVE_CATALOG_NAME = "HiveCatalog";
    private HiveCatalog hc;

    public IcebergHiveCatalog() {
        super(HIVE_CATALOG_NAME, HiveCatalog.class);
    }

    @Override
    public void initialize(Map<String, String> properties, Configuration configuration) {
        this.hc = (HiveCatalog)this.createCompanionCatalog(properties, configuration);
    }

    @Override
    public String getCatalogUri() {
        return this.hc.getConf().get(HiveConf.ConfVars.METASTOREURIS.varname, "<<not set>>");
    }

    @Override
    protected TableOperations createTableOperations(TableIdentifier tableId) {
        return this.hc.newTableOps(tableId);
    }

    @Override
    public boolean tableAlreadyExists(IcebergTable icebergTable) {
        return this.hc.tableExists(icebergTable.getTableId());
    }
}

