/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.data.management.copy.hive.HivePartitionExtendedFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    private static final Logger log = LoggerFactory.getLogger(HiveUtils.class);

    public static Map<List<String>, Partition> getPartitionsMap(IMetaStoreClient client, Table table, Optional<String> filter, Optional<? extends HivePartitionExtendedFilter> hivePartitionExtendedFilterOptional) throws IOException {
        return Maps.uniqueIndex(HiveUtils.getPartitions(client, table, filter, hivePartitionExtendedFilterOptional), (Function)new Function<Partition, List<String>>(){

            public List<String> apply(@Nullable Partition partition) {
                if (partition == null) {
                    return null;
                }
                return partition.getValues();
            }
        });
    }

    public static List<Partition> getPartitions(IMetaStoreClient client, Table table, Optional<String> filter, Optional<? extends HivePartitionExtendedFilter> hivePartitionExtendedFilterOptional) throws IOException {
        try {
            ArrayList partitions = Lists.newArrayList();
            List partitionsList = filter.isPresent() ? client.listPartitionsByFilter(table.getDbName(), table.getTableName(), (String)filter.get(), (short)-1) : client.listPartitions(table.getDbName(), table.getTableName(), (short)-1);
            for (org.apache.hadoop.hive.metastore.api.Partition p : partitionsList) {
                if (hivePartitionExtendedFilterOptional.isPresent() && !((HivePartitionExtendedFilter)hivePartitionExtendedFilterOptional.get()).accept(p)) continue;
                Partition partition = new Partition(table, p);
                partitions.add(partition);
            }
            return partitions;
        }
        catch (HiveException | TException te) {
            throw new IOException("Hive Error", te);
        }
    }

    public static List<Partition> getPartitions(IMetaStoreClient client, Table table, Optional<String> filter) throws IOException {
        return HiveUtils.getPartitions(client, table, filter, (Optional<? extends HivePartitionExtendedFilter>)Optional.absent());
    }

    public static InputFormat<?, ?> getInputFormat(StorageDescriptor sd) throws IOException {
        try {
            InputFormat inputFormat = (InputFormat)ConstructorUtils.invokeConstructor(Class.forName(sd.getInputFormat()), (Object[])new Object[0]);
            if (inputFormat instanceof JobConfigurable) {
                ((JobConfigurable)inputFormat).configure(new JobConf(HiveUtils.getHadoopConfiguration()));
            }
            return inputFormat;
        }
        catch (ReflectiveOperationException re) {
            throw new IOException("Failed to instantiate input format.", re);
        }
    }

    public static Set<Path> getPaths(InputFormat<?, ?> inputFormat, Path location) throws IOException {
        InputSplit[] splits;
        JobConf jobConf = new JobConf(HiveUtils.getHadoopConfiguration());
        HashSet paths = Sets.newHashSet();
        FileInputFormat.addInputPaths((JobConf)jobConf, (String)location.toString());
        for (InputSplit split : splits = inputFormat.getSplits(jobConf, 1000)) {
            if (!(split instanceof FileSplit)) {
                throw new IOException("Not a file split. Found " + split.getClass().getName());
            }
            FileSplit fileSplit = (FileSplit)split;
            paths.add(fileSplit.getPath());
        }
        return paths;
    }

    private static Configuration getHadoopConfiguration() {
        Configuration conf = new Configuration();
        if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            conf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        return conf;
    }

    public static boolean isPartitioned(Table table) {
        return table.isPartitioned();
    }

    public static boolean areTablePathsEquivalent(FileSystem fs, Path userSpecifiedPath, Path existingTablePath) throws IOException {
        if (userSpecifiedPath == null || existingTablePath == null) {
            log.error("User path or existing hive table path is null");
            return false;
        }
        if (userSpecifiedPath.toString().equals(existingTablePath.toString())) {
            return true;
        }
        try {
            return fs.resolvePath(existingTablePath).equals((Object)fs.resolvePath(userSpecifiedPath));
        }
        catch (FileNotFoundException e) {
            if (!userSpecifiedPath.getName().equals(existingTablePath.getName())) {
                return false;
            }
            log.warn(String.format("User specified path %s or existing table path %s does not exist, checking parents for equality", userSpecifiedPath, existingTablePath));
            return HiveUtils.areTablePathsEquivalent(fs, userSpecifiedPath.getParent(), existingTablePath.getParent());
        }
    }
}

