/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.entities.PostPublishStep;
import org.apache.gobblin.data.management.copy.entities.PrePublishStep;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveFileSet;
import org.apache.gobblin.data.management.copy.hive.HiveLocationDescriptor;
import org.apache.gobblin.data.management.copy.hive.HiveTableLocationNotMatchException;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;
import org.apache.gobblin.dataset.PartitionDescriptor;
import org.apache.gobblin.hive.HiveRegisterStep;
import org.apache.gobblin.hive.metastore.HiveMetaStoreUtils;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.SimpleHiveSpec;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.metrics.event.MultiTimingEvent;
import org.apache.gobblin.source.extractor.JobCommitPolicy;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.commit.DeleteFileCommitStep;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePartitionFileSet
extends HiveFileSet {
    private static final Logger log = LoggerFactory.getLogger(HivePartitionFileSet.class);
    private HiveCopyEntityHelper hiveCopyEntityHelper;
    private final Partition partition;
    private final Properties properties;
    private Optional<Partition> existingTargetPartition;
    private final EventSubmitter eventSubmitter;

    public HivePartitionFileSet(HiveCopyEntityHelper hiveCopyEntityHelper, Partition partition, Properties properties) {
        super(partition.getCompleteName(), hiveCopyEntityHelper.getDataset());
        this.hiveCopyEntityHelper = hiveCopyEntityHelper;
        this.partition = partition;
        this.properties = properties;
        this.existingTargetPartition = Optional.fromNullable((Object)this.hiveCopyEntityHelper.getTargetPartitions().get(this.partition.getValues()));
        this.eventSubmitter = new EventSubmitter.Builder(this.hiveCopyEntityHelper.getDataset().getMetricContext(), "hive.dataset.copy").addMetadata("Partition", this.partition.getName()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Collection<CopyEntity> generateCopyEntities() throws IOException {
        Partition targetPartition;
        Path targetPath;
        ArrayList copyEntities;
        String fileSet;
        int stepPriority;
        MultiTimingEvent multiTimer;
        Closer closer = Closer.create();
        Throwable throwable = null;
        try {
            multiTimer = (MultiTimingEvent)closer.register((Closeable)new MultiTimingEvent(this.eventSubmitter, "PartitionCopy", true));
            stepPriority = 0;
            fileSet = HiveCopyEntityHelper.gson.toJson((Object)this.partition.getValues());
            copyEntities = Lists.newArrayList();
            stepPriority = this.hiveCopyEntityHelper.addSharedSteps(copyEntities, fileSet, stepPriority);
            multiTimer.nextStage("ComputeTargets");
            targetPath = this.hiveCopyEntityHelper.getTargetLocation(this.hiveCopyEntityHelper.getTargetFs(), this.partition.getDataLocation(), (Optional<Partition>)Optional.of((Object)this.partition));
            targetPartition = this.getTargetPartition(this.partition, targetPath);
            multiTimer.nextStage("ExistingPartition");
            if (this.existingTargetPartition.isPresent()) {
                this.hiveCopyEntityHelper.getTargetPartitions().remove(this.partition.getValues());
                try {
                    this.checkPartitionCompatibility(targetPartition, (Partition)this.existingTargetPartition.get());
                }
                catch (IOException ioe) {
                    if (this.hiveCopyEntityHelper.getExistingEntityPolicy() != HiveCopyEntityHelper.ExistingEntityPolicy.REPLACE_PARTITIONS && this.hiveCopyEntityHelper.getExistingEntityPolicy() != HiveCopyEntityHelper.ExistingEntityPolicy.REPLACE_TABLE_AND_PARTITIONS) {
                        log.error("Source and target partitions are not compatible. Aborting copy of partition " + this.partition, (Throwable)ioe);
                        if (!ConfigUtils.getString((Config)this.hiveCopyEntityHelper.getConfiguration().getConfig(), (String)"job.commit.policy", (String)JobCommitPolicy.COMMIT_ON_FULL_SUCCESS.toString()).equals(JobCommitPolicy.COMMIT_SUCCESSFUL_TASKS.toString())) throw ioe;
                        ArrayList arrayList = Lists.newArrayList();
                        if (closer == null) return arrayList;
                        if (throwable == null) {
                            closer.close();
                            return arrayList;
                        }
                        try {
                            closer.close();
                            return arrayList;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return arrayList;
                        }
                    }
                    log.warn("Source and target partitions are not compatible. Will override target partition: " + ioe.getMessage());
                    log.debug("Incompatibility details: ", (Throwable)ioe);
                    stepPriority = this.hiveCopyEntityHelper.addPartitionDeregisterSteps(copyEntities, fileSet, stepPriority, this.hiveCopyEntityHelper.getTargetTable(), (Partition)this.existingTargetPartition.get());
                    this.existingTargetPartition = Optional.absent();
                }
            }
            multiTimer.nextStage("PartitionSkipPredicate");
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        if (this.hiveCopyEntityHelper.getFastPartitionSkip().isPresent() && ((Predicate)this.hiveCopyEntityHelper.getFastPartitionSkip().get()).apply((Object)this)) {
            log.info(String.format("Skipping copy of partition %s due to fast partition skip predicate.", this.partition.getCompleteName()));
            return Lists.newArrayList();
        }
        SimpleHiveSpec partitionHiveSpec = new SimpleHiveSpec.Builder(targetPath).withTable(HiveMetaStoreUtils.getHiveTable((Table)this.hiveCopyEntityHelper.getTargetTable().getTTable())).withPartition(Optional.of((Object)HiveMetaStoreUtils.getHivePartition((org.apache.hadoop.hive.metastore.api.Partition)targetPartition.getTPartition()))).build();
        HiveRegisterStep register = new HiveRegisterStep(this.hiveCopyEntityHelper.getTargetMetastoreURI(), (HiveSpec)partitionHiveSpec, this.hiveCopyEntityHelper.getHiveRegProps());
        copyEntities.add(new PostPublishStep(fileSet, Maps.newHashMap(), (CommitStep)register, stepPriority++));
        multiTimer.nextStage("CreateLocations");
        HiveLocationDescriptor sourceLocation = HiveLocationDescriptor.forPartition(this.partition, this.hiveCopyEntityHelper.getDataset().fs, this.properties);
        HiveLocationDescriptor desiredTargetLocation = HiveLocationDescriptor.forPartition(targetPartition, this.hiveCopyEntityHelper.getTargetFs(), this.properties);
        Optional existingTargetLocation = this.existingTargetPartition.isPresent() ? Optional.of((Object)HiveLocationDescriptor.forPartition((Partition)this.existingTargetPartition.get(), this.hiveCopyEntityHelper.getTargetFs(), this.properties)) : Optional.absent();
        multiTimer.nextStage("FullPathDiff");
        HiveCopyEntityHelper.DiffPathSet diffPathSet = HiveCopyEntityHelper.fullPathDiff(sourceLocation, desiredTargetLocation, (Optional<HiveLocationDescriptor>)existingTargetLocation, (Optional<Partition>)Optional.absent(), multiTimer, this.hiveCopyEntityHelper);
        multiTimer.nextStage("CreateDeleteUnits");
        if (diffPathSet.pathsToDelete.size() > 0) {
            DeleteFileCommitStep deleteStep = DeleteFileCommitStep.fromPaths(this.hiveCopyEntityHelper.getTargetFs(), diffPathSet.pathsToDelete, this.hiveCopyEntityHelper.getDataset().properties);
            copyEntities.add(new PrePublishStep(fileSet, Maps.newHashMap(), deleteStep, stepPriority++));
        }
        multiTimer.nextStage("CreateCopyUnits");
        for (CopyableFile.Builder builder : this.hiveCopyEntityHelper.getCopyableFilesFromPaths(diffPathSet.filesToCopy, this.hiveCopyEntityHelper.getConfiguration(), (Optional<Partition>)Optional.of((Object)this.partition))) {
            CopyableFile fileEntity = builder.fileSet(fileSet).checksum(new byte[0]).datasetOutputPath(desiredTargetLocation.location.toString()).build();
            DatasetDescriptor sourceDataset = this.hiveCopyEntityHelper.getSourceDataset();
            PartitionDescriptor source = new PartitionDescriptor(this.partition.getName(), sourceDataset);
            fileEntity.setSourceData((Descriptor)source);
            DatasetDescriptor destinationDataset = this.hiveCopyEntityHelper.getDestinationDataset();
            Partition destinationPartition = this.existingTargetPartition.isPresent() ? (Partition)this.existingTargetPartition.get() : this.partition;
            PartitionDescriptor destination = new PartitionDescriptor(destinationPartition.getName(), destinationDataset);
            fileEntity.setDestinationData((Descriptor)destination);
            copyEntities.add(fileEntity);
        }
        log.info("Created {} copy entities for partition {}", (Object)copyEntities.size(), (Object)this.partition.getCompleteName());
        return copyEntities;
        finally {
            if (closer != null) {
                if (throwable != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    closer.close();
                }
            }
        }
    }

    private Partition getTargetPartition(Partition originPartition, Path targetLocation) throws IOException {
        try {
            Partition targetPartition = new Partition(this.hiveCopyEntityHelper.getTargetTable(), originPartition.getTPartition().deepCopy());
            targetPartition.getTable().setDbName(this.hiveCopyEntityHelper.getTargetDatabase());
            targetPartition.getTPartition().setDbName(this.hiveCopyEntityHelper.getTargetDatabase());
            targetPartition.getTPartition().putToParameters("registerer", "gobblin-distcp");
            targetPartition.getTPartition().putToParameters("registrationGenerationTimeMillis", Long.toString(this.hiveCopyEntityHelper.getStartTime()));
            targetPartition.setLocation(targetLocation.toString());
            targetPartition.getTPartition().getSd().getSerdeInfo().getParameters().computeIfPresent("path", (k, v) -> targetLocation.toString());
            targetPartition.getTPartition().unsetCreateTime();
            return targetPartition;
        }
        catch (HiveException he) {
            throw new IOException(he);
        }
    }

    private void checkPartitionCompatibility(Partition desiredTargetPartition, Partition existingTargetPartition) throws IOException {
        if (!HiveUtils.areTablePathsEquivalent(this.hiveCopyEntityHelper.getTargetFs(), desiredTargetPartition.getDataLocation(), existingTargetPartition.getDataLocation())) {
            throw new HiveTableLocationNotMatchException(desiredTargetPartition.getDataLocation(), existingTargetPartition.getDataLocation());
        }
    }

    public HiveCopyEntityHelper getHiveCopyEntityHelper() {
        return this.hiveCopyEntityHelper;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<Partition> getExistingTargetPartition() {
        return this.existingTargetPartition;
    }

    public EventSubmitter getEventSubmitter() {
        return this.eventSubmitter;
    }
}

