/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.extractor;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.FileAwareInputStream;
import org.apache.gobblin.data.management.copy.extractor.FileAwareInputStreamExtractor;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.util.schema_check.AvroSchemaCheckStrategy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class FileAwareInputStreamExtractorWithCheckSchema
extends FileAwareInputStreamExtractor {
    public FileAwareInputStreamExtractorWithCheckSchema(FileSystem fs, CopyableFile file, WorkUnitState state) {
        super(fs, file, state);
    }

    public FileAwareInputStreamExtractorWithCheckSchema(FileSystem fs, CopyableFile file) {
        this(fs, file, null);
    }

    @Override
    protected FileAwareInputStream buildStream(FileSystem fsFromFile) throws DataRecordException, IOException {
        if (!this.schemaChecking(fsFromFile)) {
            throw new DataRecordException("Schema does not match the expected schema");
        }
        return super.buildStream(fsFromFile);
    }

    protected boolean schemaChecking(FileSystem fsFromFile) throws IOException {
        if (!this.state.getPropAsBoolean("shcema.check.enabled", false)) {
            return true;
        }
        GenericDatumReader datumReader = new GenericDatumReader();
        DataFileReader dataFileReader = new DataFileReader((SeekableInput)new FsInput(this.file.getFileStatus().getPath(), new Configuration()), (DatumReader)datumReader);
        Schema schema = dataFileReader.getSchema();
        if (this.state.getProp("gobblin.copy.expectedSchema") == null) {
            throw new IOException("Expected schema is not set properly");
        }
        Schema expectedSchema = new Schema.Parser().parse(this.state.getProp("gobblin.copy.expectedSchema"));
        AvroSchemaCheckStrategy strategy = AvroSchemaCheckStrategy.AvroSchemaCheckStrategyFactory.create(this.state);
        if (strategy == null) {
            throw new IOException("schema check strategy cannot be initialized");
        }
        return strategy.compare(expectedSchema, schema);
    }
}

