/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.RecursiveCopyableDataset;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareRecursiveCopyableDataset
extends RecursiveCopyableDataset {
    private static final Logger log = LoggerFactory.getLogger(TimeAwareRecursiveCopyableDataset.class);
    private static final String CONFIG_PREFIX = "gobblin.copy.recursive";
    public static final String DATE_PATTERN_KEY = "gobblin.copy.recursive.date.pattern";
    public static final String LOOKBACK_TIME_KEY = "gobblin.copy.recursive.lookback.time";
    public static final String DEFAULT_DATE_PATTERN_TIMEZONE = "America/Los_Angeles";
    public static final String DATE_PATTERN_TIMEZONE_KEY = "gobblin.copy.recursive.datetime.timezone";
    private final String lookbackTime;
    private final String datePattern;
    private final Period lookbackPeriod;
    private final DateTimeZone dateTimeZone;
    private final LocalDateTime currentTime;

    public TimeAwareRecursiveCopyableDataset(FileSystem fs, Path rootPath, Properties properties, Path glob) {
        super(fs, rootPath, properties, glob);
        this.lookbackTime = properties.getProperty(LOOKBACK_TIME_KEY);
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").toFormatter();
        this.lookbackPeriod = periodFormatter.parsePeriod(this.lookbackTime);
        this.datePattern = properties.getProperty(DATE_PATTERN_KEY);
        this.dateTimeZone = DateTimeZone.forID((String)properties.getProperty(DATE_PATTERN_TIMEZONE_KEY, DEFAULT_DATE_PATTERN_TIMEZONE));
        this.currentTime = LocalDateTime.now((DateTimeZone)this.dateTimeZone);
        this.validateLookbackWithDatePatternFormat(this.datePattern, this.lookbackTime);
    }

    void validateLookbackWithDatePatternFormat(String datePattern, String lookbackTime) {
        PeriodFormatterBuilder formatterBuilder;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)datePattern);
        LocalDateTime refDateTime = new LocalDateTime(2017, 1, 31, 10, 59, 59);
        String refDateTimeString = refDateTime.toString(formatter);
        if (!refDateTime.withSecondOfMinute(0).toString(formatter).equals(refDateTimeString)) {
            PeriodFormatterBuilder formatterBuilder2 = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s");
            if (!this.lookbackTimeMatchesFormat(formatterBuilder2, lookbackTime)) {
                throw new IllegalArgumentException(String.format("Expected lookback time to be in daily or hourly or minutely or secondly format, check %s", LOOKBACK_TIME_KEY));
            }
        } else if (!refDateTime.withMinuteOfHour(0).toString(formatter).equals(refDateTimeString)) {
            PeriodFormatterBuilder formatterBuilder3 = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m");
            if (!this.lookbackTimeMatchesFormat(formatterBuilder3, lookbackTime)) {
                throw new IllegalArgumentException(String.format("Expected lookback time to be in daily or hourly or minutely format, check %s", LOOKBACK_TIME_KEY));
            }
        } else if (!refDateTime.withHourOfDay(0).toString(formatter).equals(refDateTimeString)) {
            PeriodFormatterBuilder formatterBuilder4 = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h");
            if (!this.lookbackTimeMatchesFormat(formatterBuilder4, lookbackTime)) {
                throw new IllegalArgumentException(String.format("Expected lookback time to be in daily or hourly format, check %s", LOOKBACK_TIME_KEY));
            }
        } else if (!refDateTime.withDayOfMonth(1).toString(formatter).equals(refDateTimeString) && !this.lookbackTimeMatchesFormat(formatterBuilder = new PeriodFormatterBuilder().appendDays().appendSuffix("d"), lookbackTime)) {
            throw new IllegalArgumentException(String.format("Expected lookback time to be in daily format, check %s", LOOKBACK_TIME_KEY));
        }
    }

    private boolean lookbackTimeMatchesFormat(PeriodFormatterBuilder formatterBuilder, String lookbackTime) {
        try {
            formatterBuilder.toFormatter().parsePeriod(lookbackTime);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    protected List<FileStatus> getFilesAtPath(FileSystem fs, Path path, PathFilter fileFilter) throws IOException {
        LocalDateTime endDate = this.currentTime;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.datePattern);
        LocalDateTime startDate = formatter.parseLocalDateTime(endDate.minus((ReadablePeriod)this.lookbackPeriod).toString(this.datePattern));
        return this.recursivelyGetFilesAtDatePath(fs, path, "", fileFilter, 1, startDate, endDate, formatter);
    }

    public static Boolean checkPathDateTimeValidity(LocalDateTime startDate, LocalDateTime endDate, String datePath, String datePathFormat, int level) {
        String[] datePathFormatArray = datePathFormat.split("/");
        String datePathPattern = String.join((CharSequence)FileSystems.getDefault().getSeparator(), Arrays.asList(datePathFormatArray).subList(0, level - 1));
        try {
            DateTimeFormatter formatGranularity = DateTimeFormat.forPattern((String)datePathPattern);
            LocalDateTime traversedDatePathRound = formatGranularity.parseLocalDateTime(datePath);
            LocalDateTime startDateRound = formatGranularity.parseLocalDateTime(startDate.toString(datePathPattern));
            LocalDateTime endDateRound = formatGranularity.parseLocalDateTime(endDate.toString(datePathPattern));
            return !traversedDatePathRound.isBefore((ReadablePartial)startDateRound) && !traversedDatePathRound.isAfter((ReadablePartial)endDateRound);
        }
        catch (IllegalArgumentException e) {
            log.error(String.format("Cannot parse path provided %s, expected in format of %s", datePath, datePathFormat));
            return false;
        }
    }

    private List<FileStatus> recursivelyGetFilesAtDatePath(FileSystem fs, Path path, String traversedDatePath, PathFilter fileFilter, int level, LocalDateTime startDate, LocalDateTime endDate, DateTimeFormatter formatter) throws IOException {
        Iterator<FileStatus> folderIterator;
        ArrayList fileStatuses = Lists.newArrayList();
        if (!traversedDatePath.isEmpty() && !TimeAwareRecursiveCopyableDataset.checkPathDateTimeValidity(startDate, endDate, traversedDatePath, this.datePattern, level).booleanValue()) {
            return fileStatuses;
        }
        try {
            if (!fs.exists(path)) {
                return fileStatuses;
            }
            folderIterator = Arrays.asList(fs.listStatus(path)).iterator();
        }
        catch (Exception e) {
            log.warn(String.format("Error while listing paths at %s due to ", path), (Throwable)e);
            return fileStatuses;
        }
        if (this.datePattern.split(FileSystems.getDefault().getSeparator()).length == level) {
            while (folderIterator.hasNext()) {
                Path folderPath = folderIterator.next().getPath();
                String datePath = traversedDatePath.isEmpty() ? folderPath.getName() : new Path(traversedDatePath, folderPath.getName()).toString();
                try {
                    LocalDateTime folderDate = formatter.parseLocalDateTime(datePath);
                    if (folderDate.isBefore((ReadablePartial)startDate) || folderDate.isAfter((ReadablePartial)endDate)) continue;
                    fileStatuses.addAll(super.getFilesAtPath(fs, folderPath, fileFilter));
                }
                catch (IllegalArgumentException e) {
                    log.warn(String.format("Folder at path %s is not convertible to format %s. Please confirm that argument %s is valid", datePath, this.datePattern, DATE_PATTERN_KEY));
                }
            }
        } else {
            while (folderIterator.hasNext()) {
                String nextDate = folderIterator.next().getPath().getName();
                String datePath = traversedDatePath.isEmpty() ? nextDate : new Path(traversedDatePath, nextDate).toString();
                fileStatuses.addAll(this.recursivelyGetFilesAtDatePath(fs, new Path(path, nextDate), datePath, fileFilter, level + 1, startDate, endDate, formatter));
            }
        }
        return fileStatuses;
    }
}

