/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.api.client.util.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class OwnerAndPermission
implements Writable {
    private String owner;
    private String group;
    private FsPermission fsPermission;
    private List<AclEntry> aclEntries;

    public OwnerAndPermission(String owner, String group, FsPermission fsPermission) {
        this(owner, group, fsPermission, Lists.newArrayList());
    }

    public void write(DataOutput dataOutput) throws IOException {
        Text.writeString((DataOutput)dataOutput, (String)this.owner);
        Text.writeString((DataOutput)dataOutput, (String)this.group);
        this.fsPermission.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.owner = Text.readString((DataInput)dataInput);
        this.group = Text.readString((DataInput)dataInput);
        this.fsPermission = FsPermission.read((DataInput)dataInput);
    }

    public static OwnerAndPermission read(DataInput input) throws IOException {
        OwnerAndPermission oap = new OwnerAndPermission();
        oap.readFields(input);
        return oap;
    }

    public boolean hasSameOwnerAndPermission(FileSystem fs, FileStatus file) throws IOException {
        return this.hasSameFSPermission(file) && this.hasSameGroup(file) && this.hasSameOwner(file) && this.hasSameAcls(fs.getAclStatus(file.getPath()).getEntries());
    }

    private boolean hasSameGroup(FileStatus file) {
        return this.group == null || file.getGroup().equals(this.group);
    }

    private boolean hasSameOwner(FileStatus file) {
        return this.owner == null || file.getOwner().equals(this.owner);
    }

    private boolean hasSameFSPermission(FileStatus file) {
        return this.fsPermission == null || file.getPermission().equals((Object)this.fsPermission);
    }

    private boolean hasSameAcls(List<AclEntry> acls) {
        return this.aclEntries.isEmpty() || acls.equals(this.aclEntries);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public FsPermission getFsPermission() {
        return this.fsPermission;
    }

    public List<AclEntry> getAclEntries() {
        return this.aclEntries;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setFsPermission(FsPermission fsPermission) {
        this.fsPermission = fsPermission;
    }

    public void setAclEntries(List<AclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwnerAndPermission)) {
            return false;
        }
        OwnerAndPermission other = (OwnerAndPermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        FsPermission this$fsPermission = this.getFsPermission();
        FsPermission other$fsPermission = other.getFsPermission();
        if (this$fsPermission == null ? other$fsPermission != null : !this$fsPermission.equals(other$fsPermission)) {
            return false;
        }
        List<AclEntry> this$aclEntries = this.getAclEntries();
        List<AclEntry> other$aclEntries = other.getAclEntries();
        return !(this$aclEntries == null ? other$aclEntries != null : !((Object)this$aclEntries).equals(other$aclEntries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwnerAndPermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        FsPermission $fsPermission = this.getFsPermission();
        result = result * 59 + ($fsPermission == null ? 43 : $fsPermission.hashCode());
        List<AclEntry> $aclEntries = this.getAclEntries();
        result = result * 59 + ($aclEntries == null ? 43 : ((Object)$aclEntries).hashCode());
        return result;
    }

    public String toString() {
        return "OwnerAndPermission(owner=" + this.getOwner() + ", group=" + this.getGroup() + ", fsPermission=" + this.getFsPermission() + ", aclEntries=" + this.getAclEntries() + ")";
    }

    public OwnerAndPermission(String owner, String group, FsPermission fsPermission, List<AclEntry> aclEntries) {
        this.owner = owner;
        this.group = group;
        this.fsPermission = fsPermission;
        this.aclEntries = aclEntries;
    }

    private OwnerAndPermission() {
    }
}

