/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.data.management.copy.CopyConfiguration;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyManifest;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.IterableCopyableDataset;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.gobblin.data.management.copy.entities.PrePublishStep;
import org.apache.gobblin.data.management.partition.FileSet;
import org.apache.gobblin.util.commit.DeleteFileCommitStep;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestBasedDataset
implements IterableCopyableDataset {
    private static final Logger log = LoggerFactory.getLogger(ManifestBasedDataset.class);
    private static final String DELETE_FILE_NOT_EXIST_ON_SOURCE = "gobblin.copy.manifestBased.deleteFileNotExistOnSource";
    private static final String COMMON_FILES_PARENT = "gobblin.copy.manifestBased.commonFilesParent";
    private static final String PERMISSION_CACHE_TTL_SECONDS = "gobblin.copy.manifestBased.permission.cache.ttl.seconds";
    private static final String DEFAULT_PERMISSION_CACHE_TTL_SECONDS = "30";
    private static final String DEFAULT_COMMON_FILES_PARENT = "/";
    private final FileSystem fs;
    private final Path manifestPath;
    private final Properties properties;
    private final boolean deleteFileThatNotExistOnSource;
    private final String commonFilesParent;
    private final int permissionCacheTTLSeconds;

    public ManifestBasedDataset(FileSystem fs, Path manifestPath, Properties properties) {
        this.fs = fs;
        this.manifestPath = manifestPath;
        this.properties = properties;
        this.deleteFileThatNotExistOnSource = Boolean.parseBoolean(properties.getProperty(DELETE_FILE_NOT_EXIST_ON_SOURCE, "false"));
        this.commonFilesParent = properties.getProperty(COMMON_FILES_PARENT, DEFAULT_COMMON_FILES_PARENT);
        this.permissionCacheTTLSeconds = Integer.parseInt(properties.getProperty(PERMISSION_CACHE_TTL_SECONDS, DEFAULT_PERMISSION_CACHE_TTL_SECONDS));
    }

    public String datasetURN() {
        return this.manifestPath.toString();
    }

    @Override
    public Iterator<FileSet<CopyEntity>> getFileSetIterator(FileSystem targetFs, CopyConfiguration configuration) throws IOException {
        if (!this.fs.exists(this.manifestPath)) {
            throw new IOException(String.format("Manifest path %s does not exist on filesystem %s, skipping this manifest, probably due to wrong configuration of %s", this.manifestPath.toString(), this.fs.getUri().toString(), "gobblin.copy.manifestBased.manifest.location"));
        }
        if (this.fs.getFileStatus(this.manifestPath).isDirectory()) {
            throw new IOException(String.format("Manifest path %s on filesystem %s is a directory, which is not supported. Please set the manifest file locations in%s, you can specify multi locations split by '',", this.manifestPath.toString(), this.fs.getUri().toString(), "gobblin.copy.manifestBased.manifest.location"));
        }
        CopyManifest.CopyableUnitIterator manifests = null;
        ArrayList copyEntities = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        try {
            long startTime = System.currentTimeMillis();
            manifests = CopyManifest.getReadIterator(this.fs, this.manifestPath);
            Cache permissionMap = CacheBuilder.newBuilder().expireAfterAccess((long)this.permissionCacheTTLSeconds, TimeUnit.SECONDS).build();
            int numFiles = 0;
            while (manifests.hasNext()) {
                ++numFiles;
                CopyManifest.CopyableUnit file = manifests.next();
                Path fileToCopy = new Path(file.fileName);
                if (this.fs.exists(fileToCopy)) {
                    boolean existOnTarget = targetFs.exists(fileToCopy);
                    FileStatus srcFile = this.fs.getFileStatus(fileToCopy);
                    OwnerAndPermission replicatedPermission = CopyableFile.resolveReplicatedOwnerAndPermission(this.fs, srcFile, configuration);
                    if (existOnTarget && !ManifestBasedDataset.shouldCopy(targetFs, srcFile, targetFs.getFileStatus(fileToCopy), replicatedPermission)) continue;
                    CopyableFile.Builder copyableFileBuilder = CopyableFile.fromOriginAndDestination(this.fs, srcFile, fileToCopy, configuration).fileSet(this.datasetURN()).datasetOutputPath(fileToCopy.toString()).ancestorsOwnerAndPermission(CopyableFile.resolveReplicatedOwnerAndPermissionsRecursivelyWithCache(this.fs, fileToCopy.getParent(), new Path(this.commonFilesParent), configuration, (Cache<String, OwnerAndPermission>)permissionMap)).destinationOwnerAndPermission(replicatedPermission);
                    CopyableFile copyableFile = copyableFileBuilder.build();
                    copyableFile.setFsDatasets(this.fs, targetFs);
                    copyEntities.add(copyableFile);
                    if (!existOnTarget || !srcFile.isFile()) continue;
                    toDelete.add(targetFs.getFileStatus(fileToCopy));
                    continue;
                }
                if (!this.deleteFileThatNotExistOnSource || !targetFs.exists(fileToCopy)) continue;
                toDelete.add(targetFs.getFileStatus(fileToCopy));
            }
            if (!toDelete.isEmpty()) {
                DeleteFileCommitStep step = new DeleteFileCommitStep(targetFs, toDelete, this.properties, (Optional<Path>)Optional.absent());
                copyEntities.add(new PrePublishStep(this.datasetURN(), Maps.newHashMap(), step, 1));
            }
            log.info(String.format("Workunits calculation took %s milliseconds to process %s files", System.currentTimeMillis() - startTime, numFiles));
        }
        catch (JsonIOException | JsonSyntaxException e) {
            log.warn(String.format("Failed to read Manifest path %s on filesystem %s, please make sure it's in correct json format with schema {type:array, items:{type: object, properties:{id:{type:String}, fileName:{type:String}, fileGroup:{type:String}, fileSizeInBytes: {type:Long}}}}", this.manifestPath.toString(), this.fs.getUri().toString()), e);
            throw new IOException(e);
        }
        catch (Exception e) {
            log.warn(String.format("Failed to process Manifest path %s on filesystem %s, due to", this.manifestPath.toString(), this.fs.getUri().toString()), (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (manifests != null) {
                manifests.close();
            }
        }
        return Collections.singleton(new FileSet.Builder(this.datasetURN(), this).add(copyEntities).build()).iterator();
    }

    private static boolean shouldCopy(FileSystem targetFs, FileStatus fileInSource, FileStatus fileInTarget, OwnerAndPermission replicatedPermission) throws IOException {
        if (fileInSource.isDirectory() || fileInSource.getModificationTime() == fileInTarget.getModificationTime()) {
            return !replicatedPermission.hasSameOwnerAndPermission(targetFs, fileInTarget);
        }
        return fileInSource.getModificationTime() > fileInTarget.getModificationTime();
    }
}

