/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import java.util.Map;
import org.apache.gobblin.util.StringParsingUtils;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;

public class CopyResourcePool
extends ResourcePool {
    public static final String SIZE_KEY = "size";
    public static final String DEFAULT_MAX_SIZE = "10TB";
    public static final String ENTITIES_KEY = "copyEntities";
    public static final int DEFAULT_MAX_ENTITIES = 20000;
    public static final String TOLERANCE_KEY = "boundTolerance";
    public static final double DEFAULT_TOLERANCE = 2.0;
    private static final String ENTITIES_DIMENSION = "entities";
    private static final String BYTES_DIMENSION = "bytesCopied";

    public static CopyResourcePool fromConfig(Config limitedScopeConfig) {
        try {
            String sizeStr = limitedScopeConfig.hasPath(SIZE_KEY) ? limitedScopeConfig.getString(SIZE_KEY) : DEFAULT_MAX_SIZE;
            long maxSize = StringParsingUtils.humanReadableToByteCount((String)sizeStr);
            int maxEntities = limitedScopeConfig.hasPath(ENTITIES_KEY) ? limitedScopeConfig.getInt(ENTITIES_KEY) : 20000;
            double tolerance = limitedScopeConfig.hasPath(TOLERANCE_KEY) ? limitedScopeConfig.getDouble(TOLERANCE_KEY) : 2.0;
            return new CopyResourcePool((Map<String, Double>)ImmutableMap.of((Object)ENTITIES_DIMENSION, (Object)maxEntities, (Object)BYTES_DIMENSION, (Object)maxSize), (Map<String, Double>)ImmutableMap.of((Object)ENTITIES_DIMENSION, (Object)tolerance, (Object)BYTES_DIMENSION, (Object)tolerance), (Map<String, Double>)ImmutableMap.of());
        }
        catch (StringParsingUtils.FormatException fe) {
            throw new RuntimeException(fe);
        }
    }

    private CopyResourcePool(Map<String, Double> maxResources, Map<String, Double> tolerances, Map<String, Double> defaults) {
        super(maxResources, tolerances, defaults);
    }

    private CopyResourcePool(ResourcePool other) {
        super(other);
    }

    public ResourceRequirement.Builder getResourceRequirementBuilder() {
        return this.getCopyResourceRequirementBuilder();
    }

    public CopyResourceRequirementBuilder getCopyResourceRequirementBuilder() {
        return new CopyResourceRequirementBuilder(this);
    }

    protected ResourcePool contractPool(ResourceRequirement requirement) {
        ResourcePool superPool = super.contractPool(requirement);
        return new CopyResourcePool(superPool);
    }

    public class CopyResourceRequirementBuilder
    extends ResourceRequirement.Builder {
        private CopyResourceRequirementBuilder(CopyResourcePool pool) {
            super((ResourcePool)pool);
        }

        public CopyResourceRequirementBuilder setEntities(int numberOfEntities) {
            this.setRequirement(CopyResourcePool.ENTITIES_DIMENSION, numberOfEntities);
            return this;
        }

        public CopyResourceRequirementBuilder setBytes(long totalBytes) {
            this.setRequirement(CopyResourcePool.BYTES_DIMENSION, totalBytes);
            return this;
        }
    }
}

