/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.utils;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.util.HiveAvroTypeConstants;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroHiveTypeUtils {
    private static final Logger log = LoggerFactory.getLogger(AvroHiveTypeUtils.class);

    private AvroHiveTypeUtils() {
    }

    public static String generateAvroToHiveColumnMapping(Schema schema, Optional<Map<String, String>> hiveColumns, boolean topLevel, String datasetName) {
        if (topLevel && !schema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IllegalArgumentException(String.format("Schema for table must be of type RECORD. Received type: %s for dataset %s", schema.getType(), datasetName));
        }
        StringBuilder columns = new StringBuilder();
        switch (schema.getType()) {
            case RECORD: {
                boolean isFirst = true;
                if (topLevel) {
                    for (Schema.Field field : schema.getFields()) {
                        String flattenSource;
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            columns.append(", \n");
                        }
                        String type = AvroHiveTypeUtils.generateAvroToHiveColumnMapping(field.schema(), hiveColumns, false, datasetName);
                        if (hiveColumns.isPresent()) {
                            ((Map)hiveColumns.get()).put(field.name(), type);
                        }
                        if (StringUtils.isBlank((CharSequence)(flattenSource = field.getProp("flatten_source")))) {
                            flattenSource = field.name();
                        }
                        columns.append(String.format("  `%s` %s COMMENT 'from flatten_source %s'", field.name(), type, flattenSource));
                    }
                    break;
                }
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                for (Schema.Field field : schema.getFields()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        columns.append(",");
                    }
                    String type = AvroHiveTypeUtils.generateAvroToHiveColumnMapping(field.schema(), hiveColumns, false, datasetName);
                    columns.append("`").append(field.name()).append("`").append(":").append(type);
                }
                columns.append(">");
                break;
            }
            case UNION: {
                Optional<Schema> optionalType = AvroHiveTypeUtils.isOfOptionType(schema);
                if (optionalType.isPresent()) {
                    Schema optionalTypeSchema = (Schema)optionalType.get();
                    columns.append(AvroHiveTypeUtils.generateAvroToHiveColumnMapping(optionalTypeSchema, hiveColumns, false, datasetName));
                    break;
                }
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                boolean isFirst = true;
                for (Schema unionMember : schema.getTypes()) {
                    if (Schema.Type.NULL.equals((Object)unionMember.getType())) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        columns.append(",");
                    }
                    columns.append(AvroHiveTypeUtils.generateAvroToHiveColumnMapping(unionMember, hiveColumns, false, datasetName));
                }
                columns.append(">");
                break;
            }
            case MAP: {
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                columns.append("string,").append(AvroHiveTypeUtils.generateAvroToHiveColumnMapping(schema.getValueType(), hiveColumns, false, datasetName));
                columns.append(">");
                break;
            }
            case ARRAY: {
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType())).append("<");
                columns.append(AvroHiveTypeUtils.generateAvroToHiveColumnMapping(schema.getElementType(), hiveColumns, false, datasetName));
                columns.append(">");
                break;
            }
            case NULL: {
                break;
            }
            case BYTES: 
            case DOUBLE: 
            case ENUM: 
            case FIXED: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: 
            case BOOLEAN: {
                boolean isLogicalTypeSet = false;
                try {
                    String hiveSpecificLogicalType = AvroHiveTypeUtils.generateHiveSpecificLogicalType(schema);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{hiveSpecificLogicalType})) {
                        isLogicalTypeSet = true;
                        columns.append(hiveSpecificLogicalType);
                        break;
                    }
                }
                catch (AvroSerdeException ae) {
                    log.error("Failed to generate logical type string for field" + schema.getName() + " due to:", (Throwable)ae);
                }
                LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
                if (logicalType != null) {
                    switch (logicalType.getName().toLowerCase()) {
                        case "date": {
                            LogicalTypes.Date dateType = (LogicalTypes.Date)logicalType;
                            dateType.validate(schema);
                            columns.append("date");
                            isLogicalTypeSet = true;
                            break;
                        }
                        case "decimal": {
                            LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
                            decimalType.validate(schema);
                            columns.append(String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale()));
                            isLogicalTypeSet = true;
                            break;
                        }
                        case "time-millis": {
                            LogicalTypes.TimeMillis timeMillsType = (LogicalTypes.TimeMillis)logicalType;
                            timeMillsType.validate(schema);
                            columns.append("timestamp");
                            isLogicalTypeSet = true;
                            break;
                        }
                        default: {
                            log.error("Unsupported logical type" + schema.getLogicalType().getName() + ", fallback to physical type");
                        }
                    }
                }
                if (isLogicalTypeSet) break;
                columns.append((String)HiveAvroTypeConstants.AVRO_TO_HIVE_COLUMN_MAPPING_V_12.get(schema.getType()));
                break;
            }
            default: {
                String exceptionMessage = String.format("DDL query generation failed for \"%s\" of dataset %s", schema, datasetName);
                log.error(exceptionMessage);
                throw new AvroRuntimeException(exceptionMessage);
            }
        }
        return columns.toString();
    }

    public static String generateHiveSpecificLogicalType(Schema schema) throws AvroSerdeException {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.STRING && "varchar".equalsIgnoreCase(schema.getProp("logicalType"))) {
            int maxLength = 0;
            try {
                maxLength = Integer.parseInt(AvroCompatibilityHelper.getSchemaPropAsJsonString((Schema)schema, (String)"maxLength", (boolean)false, (boolean)false));
            }
            catch (Exception ex) {
                throw new AvroSerdeException("Failed to obtain maxLength value from file schema: " + schema, (Throwable)ex);
            }
            return String.format("varchar(%s)", maxLength);
        }
        return "";
    }

    private static Optional<Schema> isOfOptionType(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (!Schema.Type.UNION.equals((Object)schema.getType())) {
            return Optional.absent();
        }
        List types = schema.getTypes();
        if (null != types && types.size() == 2) {
            Schema first = (Schema)types.get(0);
            Schema second = (Schema)types.get(1);
            if (Schema.Type.NULL.equals((Object)first.getType()) && !Schema.Type.NULL.equals((Object)second.getType())) {
                return Optional.of((Object)second);
            }
            if (!Schema.Type.NULL.equals((Object)first.getType()) && Schema.Type.NULL.equals((Object)second.getType())) {
                return Optional.of((Object)first);
            }
        }
        return Optional.absent();
    }
}

