/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.provider;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.provider.HdfsBasedUpdateProvider;
import org.apache.gobblin.data.management.conversion.hive.provider.HiveUnitUpdateProvider;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class UpdateProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(UpdateProviderFactory.class);
    private static final String OPTIONAL_HIVE_UNIT_UPDATE_PROVIDER_CLASS_KEY = "hive.unit.updateProvider.class";
    private static final String DEFAULT_HIVE_UNIT_UPDATE_PROVIDER_CLASS = HdfsBasedUpdateProvider.class.getName();
    static final String UPDATE_PROVIDER_FS_URI = "hive.unit.updateProvider.fs.uri";

    public static HiveUnitUpdateProvider create(State state) {
        try {
            return (HiveUnitUpdateProvider)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(state.getProp(OPTIONAL_HIVE_UNIT_UPDATE_PROVIDER_CLASS_KEY, DEFAULT_HIVE_UNIT_UPDATE_PROVIDER_CLASS)), (List[])new List[]{ImmutableList.of((Object)UpdateProviderFactory.getFileSystem(state.getProperties())), ImmutableList.of()});
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static HiveUnitUpdateProvider create(Properties properties) {
        try {
            return (HiveUnitUpdateProvider)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(properties.getProperty(OPTIONAL_HIVE_UNIT_UPDATE_PROVIDER_CLASS_KEY, DEFAULT_HIVE_UNIT_UPDATE_PROVIDER_CLASS)), (List[])new List[]{ImmutableList.of((Object)UpdateProviderFactory.getFileSystem(properties)), ImmutableList.of()});
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileSystem getFileSystem(Properties properties) throws IOException {
        String uri = properties.getProperty(UPDATE_PROVIDER_FS_URI);
        if (uri == null) {
            return FileSystem.get((Configuration)HadoopUtils.getConfFromProperties((Properties)properties));
        }
        log.info("Using file system URI {}", (Object)uri);
        return FileSystem.get((URI)URI.create(uri), (Configuration)HadoopUtils.getConfFromProperties((Properties)properties));
    }
}

