/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.time;

import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TimeIterator
implements Iterator {
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private Granularity granularity;

    public TimeIterator(ZonedDateTime startTime, ZonedDateTime endTime, Granularity granularity) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.granularity = granularity;
    }

    @Override
    public boolean hasNext() {
        return !this.startTime.isAfter(this.endTime);
    }

    public ZonedDateTime next() {
        if (this.startTime.isAfter(this.endTime)) {
            throw new NoSuchElementException();
        }
        ZonedDateTime dateTime = this.startTime;
        this.startTime = TimeIterator.inc(this.startTime, this.granularity, 1L);
        return dateTime;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static ZonedDateTime inc(ZonedDateTime time, Granularity granularity, long units) {
        switch (granularity) {
            case MINUTE: {
                return time.plusMinutes(units);
            }
            case HOUR: {
                return time.plusHours(units);
            }
            case DAY: {
                return time.plusDays(units);
            }
            case MONTH: {
                return time.plusMonths(units);
            }
        }
        throw new RuntimeException("Unsupported granularity: " + (Object)((Object)granularity));
    }

    public static ZonedDateTime dec(ZonedDateTime time, Granularity granularity, long units) {
        switch (granularity) {
            case MINUTE: {
                return time.minusMinutes(units);
            }
            case HOUR: {
                return time.minusHours(units);
            }
            case DAY: {
                return time.minusDays(units);
            }
            case MONTH: {
                return time.minusMonths(units);
            }
        }
        throw new RuntimeException("Unsupported granularity: " + (Object)((Object)granularity));
    }

    public static enum Granularity {
        MINUTE,
        HOUR,
        DAY,
        MONTH;

    }
}

