/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.retention;

import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.retention.DatasetCleaner;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.task.BaseAbstractTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetCleanerTask
extends BaseAbstractTask {
    private static final Logger log = LoggerFactory.getLogger(DatasetCleanerTask.class);
    private static final String JOB_CONFIGURATION_PREFIX = "datasetCleaner";
    private final TaskContext taskContext;

    public DatasetCleanerTask(TaskContext taskContext) {
        super(taskContext);
        this.taskContext = taskContext;
    }

    public void run() {
        try {
            DatasetCleaner datasetCleaner = new DatasetCleaner(FileSystem.get((Configuration)new Configuration()), this.taskContext.getTaskState().getProperties());
            datasetCleaner.clean();
            this.workingState = WorkUnitState.WorkingState.SUCCESSFUL;
        }
        catch (IOException e) {
            this.workingState = WorkUnitState.WorkingState.FAILED;
            throw new RuntimeException(e);
        }
    }

    public void commit() {
        log.info("task {} commits with state {}", (Object)this.taskContext.getTaskState().getTaskId(), (Object)this.workingState);
    }
}

