/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.dataset.MultiVersionCleanableDatasetBase;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;

public abstract class CleanableDatasetBase<T extends FileSystemDatasetVersion>
extends MultiVersionCleanableDatasetBase<T>
implements CleanableDataset,
FileSystemDataset {
    public abstract VersionFinder<? extends T> getVersionFinder();

    public abstract RetentionPolicy<T> getRetentionPolicy();

    public CleanableDatasetBase(FileSystem fs, Properties props, Config config, Logger log) throws IOException {
        super(fs, props, config, log);
    }

    public CleanableDatasetBase(FileSystem fs, Properties props, Logger log) throws IOException {
        super(fs, props, log);
    }

    public CleanableDatasetBase(FileSystem fs, Properties properties, boolean simulate, boolean skipTrash, boolean deleteEmptyDirectories, boolean deleteAsOwner, boolean isDatasetBlacklisted, Logger log) throws IOException {
        super(fs, properties, simulate, skipTrash, deleteEmptyDirectories, deleteAsOwner, isDatasetBlacklisted, log);
    }

    public CleanableDatasetBase(FileSystem fs, Properties properties, boolean simulate, boolean skipTrash, boolean deleteEmptyDirectories, boolean deleteAsOwner, Logger log) throws IOException {
        super(fs, properties, simulate, skipTrash, deleteEmptyDirectories, deleteAsOwner, Boolean.parseBoolean(IS_DATASET_BLACKLISTED_DEFAULT), log);
    }

    @Override
    public List<MultiVersionCleanableDatasetBase.VersionFinderAndPolicy<T>> getVersionFindersAndPolicies() {
        return ImmutableList.of(new MultiVersionCleanableDatasetBase.VersionFinderAndPolicy<T>(this.getRetentionPolicy(), this.getVersionFinder(), ConfigFactory.empty()));
    }
}

