/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class OwnerAndPermission
implements Writable {
    private String owner;
    private String group;
    private FsPermission fsPermission;

    public void write(DataOutput dataOutput) throws IOException {
        Text.writeString((DataOutput)dataOutput, (String)this.owner);
        Text.writeString((DataOutput)dataOutput, (String)this.group);
        this.fsPermission.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.owner = Text.readString((DataInput)dataInput);
        this.group = Text.readString((DataInput)dataInput);
        this.fsPermission = FsPermission.read((DataInput)dataInput);
    }

    public static OwnerAndPermission read(DataInput input) throws IOException {
        OwnerAndPermission oap = new OwnerAndPermission();
        oap.readFields(input);
        return oap;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public FsPermission getFsPermission() {
        return this.fsPermission;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setFsPermission(FsPermission fsPermission) {
        this.fsPermission = fsPermission;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwnerAndPermission)) {
            return false;
        }
        OwnerAndPermission other = (OwnerAndPermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        FsPermission this$fsPermission = this.getFsPermission();
        FsPermission other$fsPermission = other.getFsPermission();
        return !(this$fsPermission == null ? other$fsPermission != null : !this$fsPermission.equals(other$fsPermission));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwnerAndPermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        FsPermission $fsPermission = this.getFsPermission();
        result = result * 59 + ($fsPermission == null ? 43 : $fsPermission.hashCode());
        return result;
    }

    public String toString() {
        return "OwnerAndPermission(owner=" + this.getOwner() + ", group=" + this.getGroup() + ", fsPermission=" + this.getFsPermission() + ")";
    }

    public OwnerAndPermission(String owner, String group, FsPermission fsPermission) {
        this.owner = owner;
        this.group = group;
        this.fsPermission = fsPermission;
    }

    private OwnerAndPermission() {
    }
}

