/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.gobblin.data.management.copy.CopyableDatasetMetadata;
import org.apache.gobblin.util.guid.Guid;
import org.apache.gobblin.util.guid.HasGuid;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyEntity
implements HasGuid {
    private static final Logger log = LoggerFactory.getLogger(CopyEntity.class);
    public static final Gson GSON = GsonInterfaceAdapter.getGson(Object.class);
    private String fileSet;
    private Map<String, String> additionalMetadata;

    public Guid guid() throws IOException {
        return Guid.fromStrings((String[])new String[]{this.toString()});
    }

    public static String serialize(CopyEntity copyEntity) {
        return GSON.toJson((Object)copyEntity);
    }

    public static String serializeList(List<CopyEntity> copyEntities) {
        return GSON.toJson(copyEntities, new TypeToken<List<CopyEntity>>(){}.getType());
    }

    public static CopyEntity deserialize(String serialized) {
        return (CopyEntity)GSON.fromJson(CopyEntity.getSerializedWithNewPackage(serialized), CopyEntity.class);
    }

    public static List<CopyEntity> deserializeList(String serialized) {
        return (List)GSON.fromJson(CopyEntity.getSerializedWithNewPackage(serialized), new TypeToken<List<CopyEntity>>(){}.getType());
    }

    public static String getSerializedWithNewPackage(String serialized) {
        serialized = serialized.replace("\"gobblin.data.management.", "\"org.apache.gobblin.data.management.");
        log.debug("Serialized updated copy entity: " + serialized);
        return serialized;
    }

    public String toString() {
        return CopyEntity.serialize(this);
    }

    public DatasetAndPartition getDatasetAndPartition(CopyableDatasetMetadata metadata) {
        return new DatasetAndPartition(metadata, this.getFileSet());
    }

    public String explain() {
        return this.toString();
    }

    public String getFileSet() {
        return this.fileSet;
    }

    public Map<String, String> getAdditionalMetadata() {
        return this.additionalMetadata;
    }

    public void setFileSet(String fileSet) {
        this.fileSet = fileSet;
    }

    public void setAdditionalMetadata(Map<String, String> additionalMetadata) {
        this.additionalMetadata = additionalMetadata;
    }

    protected CopyEntity(String fileSet, Map<String, String> additionalMetadata) {
        this.fileSet = fileSet;
        this.additionalMetadata = additionalMetadata;
    }

    protected CopyEntity() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyEntity)) {
            return false;
        }
        CopyEntity other = (CopyEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileSet = this.getFileSet();
        String other$fileSet = other.getFileSet();
        if (this$fileSet == null ? other$fileSet != null : !this$fileSet.equals(other$fileSet)) {
            return false;
        }
        Map<String, String> this$additionalMetadata = this.getAdditionalMetadata();
        Map<String, String> other$additionalMetadata = other.getAdditionalMetadata();
        return !(this$additionalMetadata == null ? other$additionalMetadata != null : !((Object)this$additionalMetadata).equals(other$additionalMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CopyEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileSet = this.getFileSet();
        result = result * 59 + ($fileSet == null ? 43 : $fileSet.hashCode());
        Map<String, String> $additionalMetadata = this.getAdditionalMetadata();
        result = result * 59 + ($additionalMetadata == null ? 43 : ((Object)$additionalMetadata).hashCode());
        return result;
    }

    public static class DatasetAndPartition {
        private final CopyableDatasetMetadata dataset;
        private final String partition;

        public String identifier() {
            return Hex.encodeHexString((byte[])DigestUtils.sha((String)(this.dataset.toString() + this.partition)));
        }

        public DatasetAndPartition(CopyableDatasetMetadata dataset, String partition) {
            this.dataset = dataset;
            this.partition = partition;
        }

        public CopyableDatasetMetadata getDataset() {
            return this.dataset;
        }

        public String getPartition() {
            return this.partition;
        }

        public String toString() {
            return "CopyEntity.DatasetAndPartition(dataset=" + this.getDataset() + ", partition=" + this.getPartition() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatasetAndPartition)) {
                return false;
            }
            DatasetAndPartition other = (DatasetAndPartition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CopyableDatasetMetadata this$dataset = this.getDataset();
            CopyableDatasetMetadata other$dataset = other.getDataset();
            if (this$dataset == null ? other$dataset != null : !((Object)this$dataset).equals(other$dataset)) {
                return false;
            }
            String this$partition = this.getPartition();
            String other$partition = other.getPartition();
            return !(this$partition == null ? other$partition != null : !this$partition.equals(other$partition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DatasetAndPartition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CopyableDatasetMetadata $dataset = this.getDataset();
            result = result * 59 + ($dataset == null ? 43 : ((Object)$dataset).hashCode());
            String $partition = this.getPartition();
            result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
            return result;
        }
    }
}

