/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.CopyContext;
import org.apache.gobblin.data.management.copy.CopyResourcePool;
import org.apache.gobblin.data.management.copy.PreserveAttributes;
import org.apache.gobblin.data.management.copy.prioritization.FileSetComparator;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CopyConfiguration {
    public static final String COPY_PREFIX = "gobblin.copy";
    public static final String PRESERVE_ATTRIBUTES_KEY = "gobblin.copy.preserved.attributes";
    public static final String DESTINATION_GROUP_KEY = "gobblin.copy.dataset.destination.group";
    public static final String PRIORITIZATION_PREFIX = "gobblin.copy.prioritization";
    public static final String INCLUDE_EMPTY_DIRECTORIES = "gobblin.copy.includeEmptyDirectories";
    public static final String APPLY_FILTER_TO_DIRECTORIES = "gobblin.copy.applyFilterToDirectories";
    public static final String ENFORCE_FILE_LENGTH_MATCH = "gobblin.copyenforce.fileLength.match";
    public static final String DEFAULT_ENFORCE_FILE_LENGTH_MATCH = "true";
    public static final String PRIORITIZER_ALIAS_KEY = "gobblin.copy.prioritization.prioritizerAlias";
    public static final String MAX_COPY_PREFIX = "gobblin.copy.prioritization.maxCopy";
    public static final String BINPACKING_MAX_PER_BUCKET_PREFIX = "gobblin.copy.binPacking.maxPerBucket";
    public static final String BUFFER_SIZE = "gobblin.copy.bufferSize";
    public static final String ABORT_ON_SINGLE_DATASET_FAILURE = "gobblin.copy.abortOnSingleDatasetFailure";
    public static final String STORE_REJECTED_REQUESTS_KEY = "gobblin.copy.store.rejected.requests";
    public static final String DEFAULT_STORE_REJECTED_REQUESTS = RequestAllocatorConfig.StoreRejectedRequestsConfig.MIN.name();
    private final Path publishDir;
    private final PreserveAttributes preserve;
    private final CopyContext copyContext;
    private final Optional<String> targetGroup;
    private final FileSystem targetFs;
    private final Optional<FileSetComparator> prioritizer;
    private final ResourcePool maxToCopy;
    private final String storeRejectedRequestsSetting;
    private final Config config;
    private final boolean abortOnSingleDatasetFailure;
    private final boolean enforceFileLengthMatch;

    public static CopyConfigurationBuilder builder(FileSystem targetFs, Properties properties) {
        return new CopyConfigurationBuilder(targetFs, properties);
    }

    public Config getPrioritizationConfig() {
        return ConfigUtils.getConfigOrEmpty((Config)this.config, (String)PRIORITIZATION_PREFIX);
    }

    public Path getPublishDir() {
        return this.publishDir;
    }

    public PreserveAttributes getPreserve() {
        return this.preserve;
    }

    public CopyContext getCopyContext() {
        return this.copyContext;
    }

    public Optional<String> getTargetGroup() {
        return this.targetGroup;
    }

    public FileSystem getTargetFs() {
        return this.targetFs;
    }

    public Optional<FileSetComparator> getPrioritizer() {
        return this.prioritizer;
    }

    public ResourcePool getMaxToCopy() {
        return this.maxToCopy;
    }

    public String getStoreRejectedRequestsSetting() {
        return this.storeRejectedRequestsSetting;
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean isAbortOnSingleDatasetFailure() {
        return this.abortOnSingleDatasetFailure;
    }

    public boolean isEnforceFileLengthMatch() {
        return this.enforceFileLengthMatch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyConfiguration)) {
            return false;
        }
        CopyConfiguration other = (CopyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAbortOnSingleDatasetFailure() != other.isAbortOnSingleDatasetFailure()) {
            return false;
        }
        if (this.isEnforceFileLengthMatch() != other.isEnforceFileLengthMatch()) {
            return false;
        }
        Path this$publishDir = this.getPublishDir();
        Path other$publishDir = other.getPublishDir();
        if (this$publishDir == null ? other$publishDir != null : !this$publishDir.equals(other$publishDir)) {
            return false;
        }
        PreserveAttributes this$preserve = this.getPreserve();
        PreserveAttributes other$preserve = other.getPreserve();
        if (this$preserve == null ? other$preserve != null : !((Object)this$preserve).equals(other$preserve)) {
            return false;
        }
        CopyContext this$copyContext = this.getCopyContext();
        CopyContext other$copyContext = other.getCopyContext();
        if (this$copyContext == null ? other$copyContext != null : !this$copyContext.equals(other$copyContext)) {
            return false;
        }
        Optional<String> this$targetGroup = this.getTargetGroup();
        Optional<String> other$targetGroup = other.getTargetGroup();
        if (this$targetGroup == null ? other$targetGroup != null : !this$targetGroup.equals(other$targetGroup)) {
            return false;
        }
        FileSystem this$targetFs = this.getTargetFs();
        FileSystem other$targetFs = other.getTargetFs();
        if (this$targetFs == null ? other$targetFs != null : !this$targetFs.equals(other$targetFs)) {
            return false;
        }
        Optional<FileSetComparator> this$prioritizer = this.getPrioritizer();
        Optional<FileSetComparator> other$prioritizer = other.getPrioritizer();
        if (this$prioritizer == null ? other$prioritizer != null : !this$prioritizer.equals(other$prioritizer)) {
            return false;
        }
        ResourcePool this$maxToCopy = this.getMaxToCopy();
        ResourcePool other$maxToCopy = other.getMaxToCopy();
        if (this$maxToCopy == null ? other$maxToCopy != null : !this$maxToCopy.equals(other$maxToCopy)) {
            return false;
        }
        String this$storeRejectedRequestsSetting = this.getStoreRejectedRequestsSetting();
        String other$storeRejectedRequestsSetting = other.getStoreRejectedRequestsSetting();
        if (this$storeRejectedRequestsSetting == null ? other$storeRejectedRequestsSetting != null : !this$storeRejectedRequestsSetting.equals(other$storeRejectedRequestsSetting)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CopyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAbortOnSingleDatasetFailure() ? 79 : 97);
        result = result * 59 + (this.isEnforceFileLengthMatch() ? 79 : 97);
        Path $publishDir = this.getPublishDir();
        result = result * 59 + ($publishDir == null ? 43 : $publishDir.hashCode());
        PreserveAttributes $preserve = this.getPreserve();
        result = result * 59 + ($preserve == null ? 43 : ((Object)$preserve).hashCode());
        CopyContext $copyContext = this.getCopyContext();
        result = result * 59 + ($copyContext == null ? 43 : $copyContext.hashCode());
        Optional<String> $targetGroup = this.getTargetGroup();
        result = result * 59 + ($targetGroup == null ? 43 : $targetGroup.hashCode());
        FileSystem $targetFs = this.getTargetFs();
        result = result * 59 + ($targetFs == null ? 43 : $targetFs.hashCode());
        Optional<FileSetComparator> $prioritizer = this.getPrioritizer();
        result = result * 59 + ($prioritizer == null ? 43 : $prioritizer.hashCode());
        ResourcePool $maxToCopy = this.getMaxToCopy();
        result = result * 59 + ($maxToCopy == null ? 43 : $maxToCopy.hashCode());
        String $storeRejectedRequestsSetting = this.getStoreRejectedRequestsSetting();
        result = result * 59 + ($storeRejectedRequestsSetting == null ? 43 : $storeRejectedRequestsSetting.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "CopyConfiguration(publishDir=" + this.getPublishDir() + ", preserve=" + this.getPreserve() + ", copyContext=" + this.getCopyContext() + ", targetGroup=" + this.getTargetGroup() + ", targetFs=" + this.getTargetFs() + ", prioritizer=" + this.getPrioritizer() + ", maxToCopy=" + this.getMaxToCopy() + ", storeRejectedRequestsSetting=" + this.getStoreRejectedRequestsSetting() + ", config=" + this.getConfig() + ", abortOnSingleDatasetFailure=" + this.isAbortOnSingleDatasetFailure() + ", enforceFileLengthMatch=" + this.isEnforceFileLengthMatch() + ")";
    }

    public CopyConfiguration(Path publishDir, PreserveAttributes preserve, CopyContext copyContext, Optional<String> targetGroup, FileSystem targetFs, Optional<FileSetComparator> prioritizer, ResourcePool maxToCopy, String storeRejectedRequestsSetting, Config config, boolean abortOnSingleDatasetFailure, boolean enforceFileLengthMatch) {
        this.publishDir = publishDir;
        this.preserve = preserve;
        this.copyContext = copyContext;
        this.targetGroup = targetGroup;
        this.targetFs = targetFs;
        this.prioritizer = prioritizer;
        this.maxToCopy = maxToCopy;
        this.storeRejectedRequestsSetting = storeRejectedRequestsSetting;
        this.config = config;
        this.abortOnSingleDatasetFailure = abortOnSingleDatasetFailure;
        this.enforceFileLengthMatch = enforceFileLengthMatch;
    }

    public static class CopyConfigurationBuilder {
        private FileSystem targetFs;
        private Optional<FileSetComparator> prioritizer;
        private ResourcePool maxToCopy;
        private String storeRejectedRequestsSetting;
        private Config config;
        private boolean abortOnSingleDatasetFailure;
        private boolean enforceFileLengthMatch;
        private PreserveAttributes preserve;
        private Optional<String> targetGroup;
        private CopyContext copyContext;
        private Path publishDir;

        public CopyConfigurationBuilder(FileSystem targetFs, Properties properties) {
            Preconditions.checkArgument((boolean)properties.containsKey("data.publisher.final.dir"), (Object)"Missing property data.publisher.final.dir");
            this.config = ConfigUtils.propertiesToConfig((Properties)properties);
            this.targetGroup = properties.containsKey(CopyConfiguration.DESTINATION_GROUP_KEY) ? Optional.of((Object)properties.getProperty(CopyConfiguration.DESTINATION_GROUP_KEY)) : Optional.absent();
            this.preserve = PreserveAttributes.fromMnemonicString(properties.getProperty(CopyConfiguration.PRESERVE_ATTRIBUTES_KEY));
            Path publishDirTmp = new Path(properties.getProperty("data.publisher.final.dir"));
            if (!publishDirTmp.isAbsolute()) {
                publishDirTmp = new Path(targetFs.getWorkingDirectory(), publishDirTmp);
            }
            this.publishDir = publishDirTmp;
            this.copyContext = new CopyContext();
            this.targetFs = targetFs;
            if (properties.containsKey(CopyConfiguration.PRIORITIZER_ALIAS_KEY)) {
                try {
                    this.prioritizer = Optional.of((Object)GobblinConstructorUtils.invokeLongestConstructor((Class)new ClassAliasResolver(FileSetComparator.class).resolveClass(properties.getProperty(CopyConfiguration.PRIORITIZER_ALIAS_KEY)), (Object[])new Object[]{properties}));
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException("Could not build prioritizer.", roe);
                }
            } else {
                this.prioritizer = Optional.absent();
            }
            this.maxToCopy = CopyResourcePool.fromConfig(ConfigUtils.getConfigOrEmpty((Config)this.config, (String)CopyConfiguration.MAX_COPY_PREFIX));
            this.enforceFileLengthMatch = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)CopyConfiguration.ENFORCE_FILE_LENGTH_MATCH, (String)CopyConfiguration.DEFAULT_ENFORCE_FILE_LENGTH_MATCH);
            this.storeRejectedRequestsSetting = properties.getProperty(CopyConfiguration.STORE_REJECTED_REQUESTS_KEY, DEFAULT_STORE_REJECTED_REQUESTS);
            this.abortOnSingleDatasetFailure = false;
            if (this.config.hasPath(CopyConfiguration.ABORT_ON_SINGLE_DATASET_FAILURE)) {
                this.abortOnSingleDatasetFailure = this.config.getBoolean(CopyConfiguration.ABORT_ON_SINGLE_DATASET_FAILURE);
            }
        }

        public CopyConfigurationBuilder publishDir(Path publishDir) {
            this.publishDir = publishDir;
            return this;
        }

        public CopyConfigurationBuilder preserve(PreserveAttributes preserve) {
            this.preserve = preserve;
            return this;
        }

        public CopyConfigurationBuilder copyContext(CopyContext copyContext) {
            this.copyContext = copyContext;
            return this;
        }

        public CopyConfigurationBuilder targetGroup(Optional<String> targetGroup) {
            this.targetGroup = targetGroup;
            return this;
        }

        public CopyConfigurationBuilder targetFs(FileSystem targetFs) {
            this.targetFs = targetFs;
            return this;
        }

        public CopyConfigurationBuilder prioritizer(Optional<FileSetComparator> prioritizer) {
            this.prioritizer = prioritizer;
            return this;
        }

        public CopyConfigurationBuilder maxToCopy(ResourcePool maxToCopy) {
            this.maxToCopy = maxToCopy;
            return this;
        }

        public CopyConfigurationBuilder storeRejectedRequestsSetting(String storeRejectedRequestsSetting) {
            this.storeRejectedRequestsSetting = storeRejectedRequestsSetting;
            return this;
        }

        public CopyConfigurationBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public CopyConfigurationBuilder abortOnSingleDatasetFailure(boolean abortOnSingleDatasetFailure) {
            this.abortOnSingleDatasetFailure = abortOnSingleDatasetFailure;
            return this;
        }

        public CopyConfigurationBuilder enforceFileLengthMatch(boolean enforceFileLengthMatch) {
            this.enforceFileLengthMatch = enforceFileLengthMatch;
            return this;
        }

        public CopyConfiguration build() {
            return new CopyConfiguration(this.publishDir, this.preserve, this.copyContext, this.targetGroup, this.targetFs, this.prioritizer, this.maxToCopy, this.storeRejectedRequestsSetting, this.config, this.abortOnSingleDatasetFailure, this.enforceFileLengthMatch);
        }

        public String toString() {
            return "CopyConfiguration.CopyConfigurationBuilder(publishDir=" + this.publishDir + ", preserve=" + this.preserve + ", copyContext=" + this.copyContext + ", targetGroup=" + this.targetGroup + ", targetFs=" + this.targetFs + ", prioritizer=" + this.prioritizer + ", maxToCopy=" + this.maxToCopy + ", storeRejectedRequestsSetting=" + this.storeRejectedRequestsSetting + ", config=" + this.config + ", abortOnSingleDatasetFailure=" + this.abortOnSingleDatasetFailure + ", enforceFileLengthMatch=" + this.enforceFileLengthMatch + ")";
        }
    }
}

