/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.source;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.gobblin.dataset.PartitionableDataset;
import org.apache.gobblin.source.WorkUnitStreamSource;
import org.apache.gobblin.source.workunit.BasicWorkUnitStream;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.HadoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetFinderSource<S, D>
implements WorkUnitStreamSource<S, D> {
    private static final Logger log = LoggerFactory.getLogger(DatasetFinderSource.class);
    protected final boolean drilldownIntoPartitions;

    public DatasetFinderSource(boolean drilldownIntoPartitions) {
        this.drilldownIntoPartitions = drilldownIntoPartitions;
    }

    protected abstract WorkUnit workUnitForDataset(Dataset var1);

    protected abstract WorkUnit workUnitForDatasetPartition(PartitionableDataset.DatasetPartition var1);

    public List<WorkUnit> getWorkunits(SourceState state) {
        try {
            return this.createWorkUnitStream(state).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public WorkUnitStream getWorkunitStream(SourceState state) {
        try {
            return new BasicWorkUnitStream.Builder(this.createWorkUnitStream(state).iterator()).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected IterableDatasetFinder createDatasetsFinder(SourceState state) throws IOException {
        return DatasetUtils.instantiateIterableDatasetFinder(state.getProperties(), HadoopUtils.getSourceFileSystem((State)state), null, new Object[0]);
    }

    private Stream<WorkUnit> createWorkUnitStream(SourceState state) throws IOException {
        IterableDatasetFinder datasetsFinder = this.createDatasetsFinder(state);
        Stream datasetStream = datasetsFinder.getDatasetsStream(0, null);
        if (this.drilldownIntoPartitions) {
            return datasetStream.flatMap(dataset -> {
                if (dataset instanceof PartitionableDataset) {
                    try {
                        return ((PartitionableDataset)dataset).getPartitions(0, null);
                    }
                    catch (IOException ioe) {
                        log.error("Failed to get partitions for dataset " + dataset.getUrn());
                        return Stream.empty();
                    }
                }
                return Stream.of(new DatasetWrapper((Dataset)dataset));
            }).map(this::workUnitForPartitionInternal).filter(Objects::nonNull);
        }
        return datasetStream.map(this::workUnitForDataset).filter(Objects::nonNull);
    }

    private WorkUnit workUnitForPartitionInternal(PartitionableDataset.DatasetPartition partition) {
        if (partition instanceof DatasetWrapper) {
            return this.workUnitForDataset(((DatasetWrapper)partition).dataset);
        }
        return this.workUnitForDatasetPartition(partition);
    }

    protected static class DatasetWrapper
    implements PartitionableDataset.DatasetPartition {
        private final Dataset dataset;

        public String getUrn() {
            return this.dataset.datasetURN();
        }

        @ConstructorProperties(value={"dataset"})
        public DatasetWrapper(Dataset dataset) {
            this.dataset = dataset;
        }

        public Dataset getDataset() {
            return this.dataset;
        }
    }
}

