/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.policy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewestKSelectionPolicy<T extends DatasetVersion>
implements VersionSelectionPolicy<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewestKSelectionPolicy.class);
    public static final String NEWEST_K_VERSIONS_SELECTED_KEY = "selection.newestK.versionsSelected";
    public static final String NEWEST_K_VERSIONS_NOTSELECTED_KEY = "selection.newestK.versionsNotSelected";
    public static final Integer VERSIONS_SELECTED_DEFAULT = 2;
    public static final Integer MAX_VERSIONS_ALLOWED = 1000000;
    public static final Integer MIN_VERSIONS_ALLOWED = 1;
    private final Params params;

    private NewestKSelectionPolicy(Params params) {
        this.params = params;
        LOGGER.info(String.format("Will %s %d versions of each dataset.", this.params.excludeMode ? "select" : "exclude", this.params.versionsSelected));
    }

    public NewestKSelectionPolicy(int versionsRetained, boolean excludeMode) {
        this(new Params(versionsRetained, excludeMode));
    }

    public NewestKSelectionPolicy(Properties props) {
        this(Params.createFromProps(props));
    }

    public NewestKSelectionPolicy(Config config) {
        this(Params.createFromConfig(config));
    }

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        return DatasetVersion.class;
    }

    @Override
    public Collection<T> listSelectedVersions(List<T> allVersions) {
        if (this.isExcludeMode()) {
            return this.getBoundarySafeSublist(allVersions, this.getVersionsSelected(), allVersions.size());
        }
        return this.getBoundarySafeSublist(allVersions, 0, this.getVersionsSelected());
    }

    private List<T> getBoundarySafeSublist(List<T> l, int fromIndex, int toIndex) {
        fromIndex = Math.min(fromIndex, l.size());
        toIndex = Math.min(toIndex, l.size());
        return l.subList(fromIndex, toIndex);
    }

    @VisibleForTesting
    int getVersionsSelected() {
        return this.params.getVersionsSelected();
    }

    @VisibleForTesting
    boolean isExcludeMode() {
        return this.params.isExcludeMode();
    }

    public String toString() {
        return "NewestKSelectionPolicy(params=" + this.params + ")";
    }

    private static class Params {
        private final int versionsSelected;
        private final boolean excludeMode;

        Params(int versionsSelected, boolean excludeMode) {
            Preconditions.checkArgument((versionsSelected >= MIN_VERSIONS_ALLOWED && versionsSelected <= MAX_VERSIONS_ALLOWED ? 1 : 0) != 0);
            this.versionsSelected = versionsSelected;
            this.excludeMode = excludeMode;
        }

        static Params createFromConfig(Config config) {
            if (config.hasPath(NewestKSelectionPolicy.NEWEST_K_VERSIONS_SELECTED_KEY)) {
                if (config.hasPath(NewestKSelectionPolicy.NEWEST_K_VERSIONS_NOTSELECTED_KEY)) {
                    throw new RuntimeException("Only one of selection.newestK.versionsSelected and selection.newestK.versionsNotSelected can be specified.");
                }
                return new Params(config.getInt(NewestKSelectionPolicy.NEWEST_K_VERSIONS_SELECTED_KEY), false);
            }
            if (config.hasPath(NewestKSelectionPolicy.NEWEST_K_VERSIONS_NOTSELECTED_KEY)) {
                return new Params(config.getInt(NewestKSelectionPolicy.NEWEST_K_VERSIONS_NOTSELECTED_KEY), true);
            }
            return new Params(VERSIONS_SELECTED_DEFAULT, false);
        }

        static Params createFromProps(Properties props) {
            return Params.createFromConfig(ConfigFactory.parseProperties((Properties)props));
        }

        public int getVersionsSelected() {
            return this.versionsSelected;
        }

        public boolean isExcludeMode() {
            return this.excludeMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersionsSelected() != other.getVersionsSelected()) {
                return false;
            }
            return this.isExcludeMode() == other.isExcludeMode();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Params;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersionsSelected();
            result = result * 59 + (this.isExcludeMode() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "NewestKSelectionPolicy.Params(versionsSelected=" + this.getVersionsSelected() + ", excludeMode=" + this.isExcludeMode() + ")";
        }
    }
}

