/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.dataset;

import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.copy.AllEqualComparator;
import org.apache.gobblin.data.management.dataset.SimpleDatasetRequest;
import org.apache.gobblin.data.management.dataset.SimpleDatasetRequestor;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.gobblin.util.request_allocation.SimpleHierarchicalPrioritizer;

@Alias(value="TieredDatasets")
public class SimpleDatasetHierarchicalPrioritizer
extends SimpleHierarchicalPrioritizer<SimpleDatasetRequest>
implements Serializable {
    public static final String CONFIGURATION_PREFIX = "gobblin.prioritizer.datasetTiering";
    public static final String TIER_KEY = "gobblin.prioritizer.datasetTiering.tier";
    private static final Pattern TIER_PATTERN = Pattern.compile("gobblin.prioritizer.datasetTiering.tier\\.([0-9]+)");

    public SimpleDatasetHierarchicalPrioritizer(State state) throws IOException {
        super(SimpleDatasetHierarchicalPrioritizer.createRequestorComparator(state), new AllEqualComparator());
    }

    public static Comparator<Requestor<SimpleDatasetRequest>> createRequestorComparator(State state) throws IOException {
        TreeMap tiers = Maps.newTreeMap();
        for (Map.Entry<Object, Object> entry : state.getProperties().entrySet()) {
            Matcher matcher;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(matcher = TIER_PATTERN.matcher((String)entry.getKey())).matches()) continue;
            int tier = Integer.parseInt(matcher.group(1));
            String regex = (String)entry.getValue();
            tiers.put(tier, Pattern.compile(regex));
        }
        return new TierComparator(tiers);
    }

    private static class TierComparator
    implements Comparator<Requestor<SimpleDatasetRequest>>,
    Serializable {
        private final TreeMap<Integer, Pattern> tiersMap;

        @Override
        public int compare(Requestor<SimpleDatasetRequest> o1, Requestor<SimpleDatasetRequest> o2) {
            return Integer.compare(this.findTier(o1), this.findTier(o2));
        }

        private int findTier(Requestor<SimpleDatasetRequest> requestor) {
            Dataset dataset = ((SimpleDatasetRequestor)requestor).getDataset();
            for (Map.Entry<Integer, Pattern> tier : this.tiersMap.entrySet()) {
                Pattern pattern = tier.getValue();
                if (!pattern.matcher(dataset.datasetURN()).find()) continue;
                return tier.getKey();
            }
            return Integer.MAX_VALUE;
        }

        @ConstructorProperties(value={"tiersMap"})
        public TierComparator(TreeMap<Integer, Pattern> tiersMap) {
            this.tiersMap = tiersMap;
        }
    }
}

